<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>
    <script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
    <script>
        // Carousel JS (if needed)
        $(function () {
            $('.carousel-item').eq(0).addClass('active');
            var total = $('.carousel-item').length;
            var current = 0;
            $('#moveRight').on('click', function () {
                var next = current;
                current = current + 1;
                setSlide(next, current);
            });
            $('#moveLeft').on('click', function () {
                var prev = current;
                current = current - 1;
                setSlide(prev, current);
            });
            function setSlide(prev, next) {
                var slide = current;
                if (next > total - 1) {
                    slide = 0;
                    current = 0;
                }
                if (next < 0) {
                    slide = total - 1;
                    current = total - 1;
                }
                $('.carousel-item').eq(prev).removeClass('active');
                $('.carousel-item').eq(slide).addClass('active');
                setTimeout(function () { }, 800);
                console.log('current ' + current);
                console.log('prev ' + prev);
            }
        });

        // Leaflet Map JS
        document.addEventListener("DOMContentLoaded", function () {
            var map = L.map('map').setView([24.4738, 74.8726], 9);

            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; OpenStreetMap contributors'
            }).addTo(map);

            var locations = [
                { lat: 24.460138, lng: 74.854250, label: 'Main Yard' },
                { lat: 24.508167, lng: 74.835694, label: 'Additional Yard' },
                { lat: 24.311, lng: 74.884222, label: 'Sub Yard' },
            ];

            locations.forEach(function (loc) {
                L.marker([loc.lat, loc.lng]).addTo(map).bindPopup(loc.label);
            });

            setTimeout(function () {
                map.invalidateSize();
            }, 200);
        });
    </script>