<!-- Header Section Start -->
<style>
    /* General Styles */
    .nav-big-screen {
    display: flex; /* Visible on large screens */
    justify-content: center;
    gap: 20px;
    padding: 10px 0;
}
.nav-small-screen {
    display: none; /* Hidden on large screens */
}
     .logo-section {
        display: flex;
        align-items: center;
        justify-content: space-between;
        background-image: url('backgroundim.png') !important;
        background-repeat: repeat;
        height: 103px;
        padding: 0 20px;
    }

    .logo-section img {
        height: 100px;
        width: auto;
        object-fit: contain;
    }

    /* Navigation Styles */
    .nav-list {
         display: flex; /* Ensure it is visible on larger screens */
    justify-content: center;
    gap: 20px;
    padding: 10px 0;
    list-style: none;
    margin: 0;
    }

    .nav-list li a {
        color: white;
        font-size: 16px;
        text-decoration: none;
        transition: color 0.3s;
    }

    .nav-list li a:hover {
        color: #bf8a44;
    }

    /* Side Menu Styles */
    .side-menu {
        position: fixed;
        top: 0;
        left: -250px;
        width: 250px;
        height: 100%;
        background-color: #ee9019;
        color: white;
        box-shadow: 2px 0 5px rgba(0, 0, 0, 0.5);
        transition: left 0.3s ease;
        padding: 20px;
        z-index: 9999;
         overflow-y: auto;
    }

    .side-menu ul {
        list-style: none;
        padding: 0;
        margin: 0;
    }

    .side-menu ul li {
        margin-bottom: 15px;
    }

    .side-menu ul li a {
        color: white;
        text-decoration: none;
        font-size: 18px;
    }

    .side-menu ul li a:hover {
        color: #bf8a44;
    }

    .menu-toggle {
        display: block; /* Hidden on large screens */
        font-size: 24px;
        cursor: pointer;
        color: white;
        background-color: #ee9019;
        border: none;
        padding: 10px;
    }

    .close-btn {
        font-size: 24px;
        cursor: pointer;
        color: white;
        background-color: transparent;
        border: none;
        position: absolute;
        top: 10px;
        right: 10px;
    }

    @media (max-width: 991px) {
        .nav-big-screen {
        display: none; /* Hide on medium and small screens */
    }

    .nav-small-screen {
        display: block; /* Show on medium and small screens */
    }

    .menu-toggle {
        display: block; /* Show menu toggle button */
    }
        .nav-list {
            display: none;
        }

        .menu-toggle {
            display: block;
        }
        .logo-section {
            flex-direction: column;
            height: auto;
            padding: 10px;
        }

        .logo-section img {
            height: 80px;
            margin-bottom: 10px;
        }
    }
     @media (max-width: 576px) {
        .logo-section img {
            height: 60px;
        }
    }
</style>

<header>
    <!-- Top Bar -->
    <div class="container-fluid" style="background-color: #ee9019; color: white;">
        <div class="row">
            <div class="col-md-6 col-sm-12 text-center text-md-start">
                <h3 style="font-size:16px; padding: 10px;">AWMNEE@NIC.IN</h3>
            </div>
            <div class="col-md-6 col-sm-12 text-center text-md-end" >
                <ul class="nav justify-content-center justify-content-md-end">
                    <li class="brd"><span class="zoomIn" style="cursor: pointer;">A <i class="icon-zoom-in iconSty"></i>+</span></li>
                    <li class="brd"><span class="zoomOff" style="cursor: pointer;">A</span></li>
                    <li class="brd"><span class="zoomOut" style="cursor: pointer;">A-</span></li>
                </ul>
            </div>
        </div>
    </div>

    <!-- Logo Section -->
    <div class="container-fluid logo-section">
        <img src="logo.png" alt="Logo">
        <img src="logo2.png" alt="Logo">
        <img src="logo1.png" alt="Logo">
    </div>

    <!-- Navigation Section for Big Screens -->
    <div class="container-fluid nav-big-screen" style="background-color: #ee9019; color: white;">
        <ul class="nav-list">
            <li><a href="index.php">Home</a></li>
            <li><a href="about.php">About Us</a></li>
            <li><a href="crop.php">Crop Arrival Info</a></li>
            <li><a href="trader.php">Trader Information</a></li>
            <li><a href="crop_information.php">Crop Information</a></li>
            <li><a href="#">Our Location</a></li>
            <li><a href="contact.php">Contact</a></li>
        </ul>
    </div>

    <!-- Navigation Section for Medium and Small Screens -->
    <div class="container-fluid nav-small-screen" style="background-color: #ee9019; color: white;">
    <button class="menu-toggle" onclick="toggleMenu()">☰</button>
    <div class="side-menu" id="sideMenu">
        <button class="close-btn" onclick="toggleMenu()">×</button>
        <ul class="nav-list">
            <li><a href="index.php">Home</a></li>
            <li><a href="about.php">About Us</a></li>
            <li><a href="crop.php">Crop Arrival Info</a></li>
            <li><a href="trader.php">Trader Information</a></li>
            <li><a href="crop_information.php">Crop Information</a></li>
            <li><a href="#">Our Location</a></li>
            <li><a href="contact.php">Contact</a></li>
        </ul>
    </div>
</div>
</header>

<script>
   function toggleMenu() {
    const sideMenu = document.getElementById('sideMenu');
    if (sideMenu.style.left === '0px') {
        sideMenu.style.left = '-250px'; // Hide the menu
    } else {
        sideMenu.style.left = '0px'; // Show the menu
    }
}
</script>
<!-- Header Section End -->