<?php

class PxlButtonCustom_Widget extends Pxltheme_Core_Widget_Base{
    protected $name = 'pxl_button_custom';
    protected $title = 'Case Button Custom';
    protected $icon = 'eicon-button';
    protected $categories = array( 'pxltheme-core' );
    protected $params = '{"sections":[{"name":"tab_content","label":"Content","tab":"content","controls":[{"name":"title","label":"Title","type":"text","label_block":true},{"name":"button_link","label":"Link","type":"url"},{"name":"align","label":"Alignment","type":"choose","control_type":"responsive","options":{"left":{"title":"Left","icon":"fa fa-align-left"},"center":{"title":"Center","icon":"fa fa-align-center"},"right":{"title":"Right","icon":"fa fa-align-right"},"justify":{"title":"Justified","icon":"fa fa-align-justify"}},"prefix_class":"elementor-align-","default":"","selectors":{"{{WRAPPER}} .pxl-button-custom":"text-align: {{VALUE}}"}}]},{"name":"tab_style","label":"Button Video","tab":"style","controls":[{"name":"style","label":"Style","type":"select","options":{"style-default":"Style Default"},"default":"style-default"},{"name":"video_color","label":"Color","type":"color","selectors":{"{{WRAPPER}} .pxl-button-custom .pxl-btn":"color: {{VALUE}};"}},{"name":"video_typography","label":"Typography","type":"typography","control_type":"group","selector":"{{WRAPPER}} .pxl-button-custom .pxl-btn"},{"name":"video_width","label":"Video Width","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-button-custom .pxl-btn":"min-width: {{SIZE}}{{UNIT}}; width: {{SIZE}}{{UNIT}};"}},{"name":"video_height","label":"Video Height","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":300}},"selectors":{"{{WRAPPER}} .pxl-button-custom .pxl-btn":"height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};"}},{"name":"button_effect","label":"Button Effect","type":"select","options":{"":"None","pxl-image-effect1":"Zigzag","pxl-image-tilt":"Tilt","pxl-image-spin-normal":"Spin","pxl-image-spin":"Spin Reverse","pxl-image-zoom":"Zoom","pxl-image-bounce":"Bounce","slide-up-down":"Slide Up Down","slide-top-to-bottom":"Slide Top To Bottom ","pxl-image-effect2":"Slide Bottom To Top ","slide-right-to-left":"Slide Right To Left ","slide-left-to-right":"Slide Left To Right ","pxl-hover1":"ZoomIn","pxl-hover2":"ZoomOut","pxl-animation-round":"Round","pxl-image-parallax":"Parallax"},"default":""},{"name":"parallax_value","label":"Parallax Value","type":"text","condition":{"button_effect":"pxl-image-parallax"},"default":"40","description":"Enter number."},{"name":"max_tilt","label":"Max Tilt","type":"text","condition":{"button_effect":"pxl-image-tilt"},"default":"10","description":"Enter number."},{"name":"speed_tilt","label":"Speed Tilt","type":"text","condition":{"button_effect":"pxl-image-tilt"},"default":"400","description":"Enter number."},{"name":"perspective_tilt","label":"Perspective Tilt","type":"text","condition":{"button_effect":"pxl-image-tilt"},"default":"1000","description":"Enter number."},{"name":"speed_effect","label":"Speed","type":"slider","control_type":"responsive","size_units":["px"],"range":{"px":{"min":0,"max":100000}},"selectors":{"{{WRAPPER}} .pxl-item--image":"animation-duration: {{SIZE}}ms;"},"condition":{"button_effect!":["pxl-image-tilt","pxl-hover1"]},"description":"Enter number, unit is ms."}]},{"name":"section_animation","label":"Animation","tab":"style","condition":[],"controls":[{"name":"pxl_animate","label":"Case Animate","type":"select","options":{"":"None","wow bounce":"bounce","wow flash":"flash","wow pulse":"pulse","wow rubberBand":"rubberBand","wow shake":"shake","wow swing":"swing","wow tada":"tada","wow wobble":"wobble","wow bounceIn":"bounceIn","wow bounceInDown":"bounceInDown","wow bounceInLeft":"bounceInLeft","wow bounceInRight":"bounceInRight","wow bounceInUp":"bounceInUp","wow bounceOut":"bounceOut","wow bounceOutDown":"bounceOutDown","wow bounceOutLeft":"bounceOutLeft","wow bounceOutRight":"bounceOutRight","wow bounceOutUp":"bounceOutUp","wow fadeIn":"fadeIn","wow fadeInDown":"fadeInDown","wow fadeInDownBig":"fadeInDownBig","wow fadeInLeft":"fadeInLeft","wow fadeInLeftBig":"fadeInLeftBig","wow fadeInRight":"fadeInRight","wow fadeInRightBig":"fadeInRightBig","wow fadeInUp":"fadeInUp","wow fadeInUpBig":"fadeInUpBig","wow fadeOut":"fadeOut","wow fadeOutDown":"fadeOutDown","wow fadeOutDownBig":"fadeOutDownBig","wow fadeOutLeft":"fadeOutLeft","wow fadeOutLeftBig":"fadeOutLeftBig","wow fadeOutRight":"fadeOutRight","wow fadeOutRightBig":"fadeOutRightBig","wow fadeOutUp":"fadeOutUp","wow fadeOutUpBig":"fadeOutUpBig","wow flip":"flip","wow flipCase":"flipCase","wow flipInX":"flipInX","wow flipInY":"flipInY","wow flipOutX":"flipOutX","wow flipOutY":"flipOutY","wow lightSpeedIn":"lightSpeedIn","wow lightSpeedOut":"lightSpeedOut","wow rotateBg":"rotateBg","wow rotateIn":"rotateIn","wow rotateInDownLeft":"rotateInDownLeft","wow rotateInDownRight":"rotateInDownRight","wow rotateInUpLeft":"rotateInUpLeft","wow rotateInUpRight":"rotateInUpRight","wow rotateOut":"rotateOut","wow rotateOutDownLeft":"rotateOutDownLeft","wow rotateOutDownRight":"rotateOutDownRight","wow rotateOutUpLeft":"rotateOutUpLeft","wow rotateOutUpRight":"rotateOutUpRight","wow hinge":"hinge","wow rollIn":"rollIn","wow rollOut":"rollOut","wow zoomInSmall":"zoomInSmall","wow zoomIn":"zoomInBig","wow zoomOut":"zoomOut","wow skewIn":"skewInLeft","wow skewInRight":"skewInRight","wow skewInBottom":"skewInBottom","wow RotatingY":"RotatingY","wow PXLfadeInUp":"PXLfadeInUp","fadeInPopup":"fadeInPopup","pxl-transform-left":"PXLbltaLeft","pxl-transform-right":"PXLbltaRight","pxl-slip-text-color":"Slip Text Color","wow pxl-bounce-animation":"Pxl Bounce Animation","wow drawRightToLeft":"Svg Draw"},"default":""},{"name":"pxl_animate_delay","label":"Animate Delay","type":"text","default":"0","description":"Enter number. Default 0ms"}]}]}';
    protected $styles = array(  );
    protected $scripts = array( 'tilt','pxl-tweenmax' );
}