<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Case-Themes
 */
$sg_post_item_title = agenzio()->get_theme_opt('sg_post_item_title', 'default');
$sg_post_title_custom = agenzio()->get_theme_opt('sg_post_title_custom');
?>
<article id="pxl-post-<?php the_ID(); ?>" <?php post_class('pxl---post'); ?>>
    <div class="pxl-item--holder">
        <?php agenzio()->blog->get_post_metas(); ?>
    </div>
    <?php if (has_post_thumbnail()) {
        echo '<div class="pxl-item--image">'; ?>
            <?php the_post_thumbnail('agenzio-large'); ?>
        <?php echo '</div>';
    }?>
    <div class="pxl-post-inner">
        <h2 class="pxl-item--title">
            <?php if (is_singular('post') && $sg_post_item_title == 'custom_text' && !empty($sg_post_title_custom)) { ?>
                <?php echo pxl_print_html($sg_post_title_custom); ?>
            <?php } else { ?>
                <?php the_title(); ?>
            <?php } ?>
        </h2>
        <div class="pxl-item--content clearfix">
            <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
    </div>
</article><!-- #post -->