<?php
/**
 * @package Case-Themes
 */
$featured_img_size = agenzio()->get_theme_opt('featured_img_size', 'full');
$post_video_link = get_post_meta( $post->ID, 'post_video_link', true );
?>
<article id="post-<?php the_ID(); ?>" <?php post_class('pxl---post pxl-item--archive pxl-item--standard'); ?>>
    <div class="pxl-item-inner">
        <?php agenzio()->blog->get_archive_meta(); ?>
        <?php if (has_post_thumbnail()) {
            $img  = pxl_get_image_by_size( array(
                'attach_id'  => get_post_thumbnail_id($post->ID),
                'thumb_size' => $featured_img_size,
            ) );
            $thumbnail    = $img['thumbnail'];
            echo '<div class="pxl-item--image">'; ?>
                <a href="<?php echo esc_url( get_permalink()); ?>"><?php echo pxl_print_html($thumbnail); ?></a>
                <div class="pxl-post-video pxl-video-player">
                    <?php if(!empty($post_video_link)) : ?>
                        <a class="pxl-btn-video pxl-action-popup" href="<?php echo esc_url($post_video_link); ?>">
                            <i class="caseicon-play1"></i>
                        </a>
                    <?php endif; ?>
                </div>
            <?php echo '</div>';
        } ?>
        <div class="pxl-item--holder">
            <h2 class="pxl-item--title">
                <a href="<?php echo esc_url( get_permalink()); ?>" title="<?php the_title_attribute(); ?>">
                    <?php if(is_sticky()) { ?>
                        <i class="caseicon-check-mark pxl-mr-4"></i>
                    <?php } ?>
                    <?php the_title(); ?>
                </a>
            </h2>
        </div>
    </div>
</article>