<?php
 
add_action( 'pxl_post_metabox_register', 'agenzio_page_options_register' );
function agenzio_page_options_register( $metabox ) {
 
	$panels = [
		'post' => [
			'opt_name'            => 'post_option',
			'display_name'        => esc_html__( 'Post Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'post_settings' => [
					'title'  => esc_html__( 'Post Options', 'agenzio' ),
					'icon'   => 'el el-cog',
					'fields' => array_merge(
						agenzio_sidebar_pos_opts(['prefix' => 'post_', 'default' => true, 'default_value' => '-1']),
						array(
							array(
								'id'=>'custom_post_number_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Number For Post', 'agenzio'),
							),
							array(
					            'id'=> 'post_video_link',
					            'type' => 'text',
					            'title' => esc_html__('Video Link', 'agenzio'),
					            'validate' => 'url',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'agenzio' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
					    )
					)
				]
			]
		],
		'page' => [
			'opt_name'            => 'pxl_page_options',
			'display_name'        => esc_html__( 'Page Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'Header', 'agenzio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
				        agenzio_header_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						agenzio_header_mobile_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'header_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Header Display', 'agenzio'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'agenzio'),
				                    'hide'  => esc_html__('Hide', 'agenzio'),
				                ),
				                'default'  => 'show',
				            ),
				            array(
				           		'id'       => 'logo_m',
					            'type'     => 'media',
					            'title'    => esc_html__('Mobile Logo', 'agenzio'),
					            'default'  => '',
					            'url'      => false,
					        ),
					        array(
				                'id'       => 'p_menu',
				                'type'     => 'select',
				                'title'    => esc_html__( 'Menu', 'agenzio' ),
				                'options'  => agenzio_get_nav_menu_slug(),
				                'default' => '',
				            ),
					    ),
					    array(
				            array(
				                'id'       => 'sticky_scroll',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Sticky Scroll', 'agenzio'),
				                'options'  => array(
				                    '-1' => esc_html__('Inherit', 'agenzio'),
				                    'pxl-sticky-stt' => esc_html__('Scroll To Top', 'agenzio'),
				                    'pxl-sticky-stb'  => esc_html__('Scroll To Bottom', 'agenzio'),
				                ),
				                'default'  => '-1',
				            ),
				            array(
				                'id'       => 'header_margin',
				                'type'     => 'spacing',
				                'mode'     => 'margin',
				                'title'    => esc_html__('Margin', 'agenzio'),
				                'width'    => false,
				                'unit'     => 'px',
				                'output'    => array('#pxl-header-elementor .pxl-header-elementor-main'),
				            ),
				        )
				    )
					 
				],
				'page_title' => [
					'title'  => esc_html__( 'Page Title', 'agenzio' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        agenzio_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
				'content' => [
					'title'  => esc_html__( 'Content', 'agenzio' ),
					'icon'   => 'el-icon-pencil',
					'fields' => array_merge(
						agenzio_sidebar_pos_opts(['prefix' => 'page_', 'default' => false, 'default_value' => '0']),
						array(
							array(
					            'id' => 'page_title_name',
					            'type' => 'text',
					            'title' => esc_html__('Page Title', 'agenzio'),
					        ),
					        array(
					            'id' => 'sub_page_title',
					            'type' => 'text',
					            'title' => esc_html__('Sub Page Title', 'agenzio'),
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Spacing Top/Bottom', 'agenzio' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							), 
					    )
					)
				],
				'footer' => [
					'title'  => esc_html__( 'Footer', 'agenzio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        agenzio_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						]),
						array(
							array(
				                'id'       => 'footer_display',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Display', 'agenzio'),
				                'options'  => array(
				                    'show' => esc_html__('Show', 'agenzio'),
				                    'hide'  => esc_html__('Hide', 'agenzio'),
				                ),
				                'default'  => 'show',
				            ),
							array(
				                'id'       => 'p_footer_fixed',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Footer Fixed', 'agenzio'),
				                'options'  => array(
				                    'inherit' => esc_html__('Inherit', 'agenzio'),
				                    'on' => esc_html__('On', 'agenzio'),
				                    'off' => esc_html__('Off', 'agenzio'),
				                ),
				                'default'  => 'inherit',
				            ),
				            array(
				                'id'       => 'back_top_top_style',
				                'type'     => 'button_set',
				                'title'    => esc_html__('Back to Top Style', 'agenzio'),
				                'options'  => array(
				                    'style-default' => esc_html__('Default', 'agenzio'),
				                    'style-round' => esc_html__('Round', 'agenzio'),
				                ),
				                'default'  => 'style-default',
				            ),
						)
				    )
				],
				'colors' => [
					'title'  => esc_html__( 'Colors', 'agenzio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id'          => 'body_bg_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Body Background Color', 'agenzio'),
					            'transparent' => false,
					            'default'     => ''
					        ),
				        	array(
					            'id'          => 'primary_color',
					            'type'        => 'color',
					            'title'       => esc_html__('Primary Color', 'agenzio'),
					            'transparent' => false,
					            'default'     => ''
					        ),
					        array(
					            'id'          => 'gradient_color',
					            'type'        => 'color_gradient',
					            'title'       => esc_html__('Gradient Color', 'agenzio'),
					            'transparent' => false,
					            'default'  => array(
					                'from' => '',
					                'to'   => '', 
					            ),
					        ),
					    )
				    )
				],
				'extra' => [
					'title'  => esc_html__( 'Extra', 'agenzio' ),
					'icon'   => 'el el-website',
					'fields' => array_merge(
				        array(
				        	array(
					            'id' => 'body_custom_class',
					            'type' => 'text',
					            'title' => esc_html__('Body Custom Class', 'agenzio'),
					        ),
					    )
				    )
				]
			]
		],
		'portfolio' => [
			'opt_name'            => 'pxl_portfolio_options',
			'display_name'        => esc_html__( 'Portfolio Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agenzio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
                                'id'          => 'client',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Client', 'agenzio' ),
                            ),
                            array(
                                'id'          => 'total_value',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Total Value', 'agenzio' ),
                            ),
                            array(
                                'id'          => 'pledge',
                                'type'        => 'text',
                                'title'       => esc_html__( 'Pledge', 'agenzio' ),
                            ),
							array(
					            'id'=> 'portfolio_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'agenzio'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'=>'custom_portfolio_number_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Number For Portfolio', 'agenzio'),
							),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'agenzio' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_portfolio_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For portfolio', 'agenzio'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For portfolio', 'agenzio'),
							),
						),
						agenzio_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],

		'service' => [
			'opt_name'            => 'pxl_service_options',
			'display_name'        => esc_html__( 'Service Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agenzio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'service_external_link',
					            'type' => 'text',
					            'title' => esc_html__('External Link', 'agenzio'),
					            'validate' => 'url',
					            'default' => '',
					        ),
							array(
					            'id'=> 'service_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'agenzio'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
					            'id'       => 'service_icon_type',
					            'type'     => 'button_set',
					            'title'    => esc_html__('Icon Type', 'agenzio'),
					            'options'  => array(
					                'icon'  => esc_html__('Icon', 'agenzio'),
					                'image'  => esc_html__('Image', 'agenzio'),
					            ),
					            'default'  => 'icon'
					        ),
					        array(
					            'id'       => 'service_icon_font',
					            'type'     => 'pxl_iconpicker',
					            'title'    => esc_html__('Icon', 'agenzio'),
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'icon' ),
            					'force_output' => true
					        ),
					        array(
					            'id'       => 'service_icon_img',
					            'type'     => 'media',
					            'title'    => esc_html__('Icon Image', 'agenzio'),
					            'default' => '',
					            'required' => array( 0 => 'service_icon_type', 1 => 'equals', 2 => 'image' ),
				            	'force_output' => true
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'agenzio' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_service_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For service', 'agenzio'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For service', 'agenzio'),
							),
						),
						agenzio_footer_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],

		'career' => [
			'opt_name'            => 'pxl_career_options',
			'display_name'        => esc_html__( 'Career Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agenzio' ),
					'icon'   => 'el-icon-website',
					'fields' => array_merge(
						array(
							array(
					            'id'=> 'career_excerpt',
					            'type' => 'textarea',
					            'title' => esc_html__('Excerpt', 'agenzio'),
					            'validate' => 'html_custom',
					            'default' => '',
					        ),
					        array(
								'id'             => 'content_spacing',
								'type'           => 'spacing',
								'output'         => array( '#pxl-wapper #pxl-main' ),
								'right'          => false,
								'left'           => false,
								'mode'           => 'margin',
								'units'          => array( 'px' ),
								'units_extended' => 'false',
								'title'          => esc_html__( 'Content Spacing Top/Bottom', 'agenzio' ),
								'default'        => array(
									'margin-top'    => '',
									'margin-bottom' => '',
									'units'          => 'px',
								)
							),
							array(
								'id'=>'custom_career_title_carousel',
								'type' => 'text',
								'title'    => esc_html__('Custom Title For career', 'agenzio'),
							),
							array(
								'id'=>'button_text',
								'type' => 'text',
								'title'    => esc_html__('Custom button text For career', 'agenzio'),
							),
						)
				    )
				],
				'career_page_title' => [
					'title'  => esc_html__( 'Career Page Title', 'agenzio' ),
					'icon'   => 'el el-indent-left',
					'fields' => array_merge(
				        agenzio_page_title_opts([
							'default'         => true,
							'default_value'   => '-1'
						])
				    )
				],
			]
		],

		'pxl-template' => [ //post_type
			'opt_name'            => 'pxl_hidden_template_options',
			'display_name'        => esc_html__( 'Template Options', 'agenzio' ),
			'show_options_object' => false,
			'context'  => 'advanced',
			'priority' => 'default',
			'sections'  => [
				'header' => [
					'title'  => esc_html__( 'General', 'agenzio' ),
					'icon'   => 'el-icon-website',
					'fields' => array(
						array(
							'id'    => 'template_type',
							'type'  => 'select',
							'title' => esc_html__('Type', 'agenzio'),
				            'options' => [
				            	'df'       	   => esc_html__('Select Type', 'agenzio'), 
								'header'       => esc_html__('Header Desktop', 'agenzio'),
								'header-mobile'       => esc_html__('Header Mobile', 'agenzio'),
								'footer'       => esc_html__('Footer', 'agenzio'), 
								'mega-menu'    => esc_html__('Mega Menu', 'agenzio'), 
								'page-title'   => esc_html__('Page Title', 'agenzio'), 
								'tab' => esc_html__('Tab', 'agenzio'),
								'hidden-panel' => esc_html__('Hidden Panel', 'agenzio'),
								'popup' => esc_html__('Popup', 'agenzio'),
								'page' => esc_html__('Page', 'agenzio'),
								'slider' => esc_html__('Slider', 'agenzio'),
								'wgaboutauthor' => esc_html__('Widget Sidebar', 'agenzio'),
				            ],
				            'default' => 'df',
				        ),
				        array(
							'id'    => 'header_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'agenzio'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'agenzio'), 
								'px-header--transparent'       => esc_html__('Transparent', 'agenzio'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header' ),
				        ),

				        array(
							'id'    => 'header_mobile_type',
							'type'  => 'select',
							'title' => esc_html__('Header Type', 'agenzio'),
				            'options' => [
				            	'px-header--default'       	   => esc_html__('Default', 'agenzio'), 
								'px-header--transparent'       => esc_html__('Transparent', 'agenzio'),
				            ],
				            'default' => 'px-header--default',
				            'indent' => true,
                			'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'header-mobile' ),
				        ),

				        array(
							'id'    => 'hidden_panel_position',
							'type'  => 'select',
							'title' => esc_html__('Hidden Panel Position', 'agenzio'),
				            'options' => [
				            	'top'       	   => esc_html__('Top', 'agenzio'),
				            	'right'       	   => esc_html__('Right', 'agenzio'),
				            ],
				            'default' => 'right',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_height',
				            'type'        => 'text',
				            'title'       => esc_html__('Hidden Panel Height', 'agenzio'),
				            'subtitle'       => esc_html__('Enter number.', 'agenzio'),
				            'transparent' => false,
				            'default'     => '',
				            'force_output' => true,
				            'required' => array( 0 => 'hidden_panel_position', 1 => 'equals', 2 => 'top' ),
				        ),
				        array(
				            'id'          => 'hidden_panel_boxcolor',
				            'type'        => 'color',
				            'title'       => esc_html__('Box Color', 'agenzio'),
				            'transparent' => false,
				            'default'     => '',
				            'required' => array( 0 => 'template_type', 1 => 'equals', 2 => 'hidden-panel' ),
				        ),
					),
				    
				],
			]
		],
	];
 
	$metabox->add_meta_data( $panels );
}
 