<?php if(!function_exists('agenzio_configs')){
    function agenzio_configs($value){
        $configs = [
            'theme_colors' => [
                'primary'   => [
                    'title' => esc_html__('Primary', 'agenzio'), 
                    'value' => agenzio()->get_opt('primary_color', '#E44F39')
                ],
                'secondary'   => [
                    'title' => esc_html__('Secondary', 'agenzio'), 
                    'value' => agenzio()->get_opt('secondary_color', '#666666')
                ],
                'third'   => [
                    'title' => esc_html__('Third', 'agenzio'), 
                    'value' => agenzio()->get_opt('third_color', '#666666')
                ],
                'dark'   => [
                    'title' => esc_html__('Dark', 'agenzio'), 
                    'value' => agenzio()->get_opt('dark_color', '#666666')
                ],
                'body-bg'   => [
                    'title' => esc_html__('Body Background Color', 'agenzio'), 
                    'value' => agenzio()->get_page_opt('body_bg_color', '#fff')
                ]
            ],
            'link' => [
                'color' => agenzio()->get_opt('link_color', ['regular' => '#232323'])['regular'],
                'color-hover'   => agenzio()->get_opt('link_color', ['hover' => '#E44F39'])['hover'],
                'color-active'  => agenzio()->get_opt('link_color', ['active' => '#E44F39'])['active'],
            ],
            'gradient' => [
                'color-from' => agenzio()->get_opt('gradient_color', ['from' => '#fff'])['from'],
                'color-to' => agenzio()->get_opt('gradient_color', ['to' => '#E44F39'])['to'],
            ],
               
        ];
        return $configs[$value];
    }
}
if(!function_exists('agenzio_inline_styles')) {
    function agenzio_inline_styles() {  
        
        $theme_colors      = agenzio_configs('theme_colors');
        $link_color        = agenzio_configs('link');
        $gradient_color    = agenzio_configs('gradient');
        ob_start();
        echo ':root{';
            
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color: %2$s;', str_replace('#', '',$color),  $value['value']);
            }
            foreach ($theme_colors as $color => $value) {
                printf('--%1$s-color-rgb: %2$s;', str_replace('#', '',$color),  agenzio_hex_rgb($value['value']));
            }
            foreach ($link_color as $color => $value) {
                printf('--link-%1$s: %2$s;', $color, $value);
            }
            foreach ($gradient_color as $color => $value) {
                printf('--gradient-%1$s: %2$s;', $color, $value);
            }
        echo '}';

        return ob_get_clean();
         
    }
}
 