<?php
$html_id = pxl_get_element_id($settings);
wp_enqueue_script('stellar-parallax');
?>
<?php if(isset($settings['title']) && !empty($settings['title']) && count($settings['title'])): ?>
    <div class="pxl-title-slide pxl-title-slide1">
        <div class="pxl-inner-slide slider-container">
            <div class="pxl-text-slick">
                <?php foreach ($settings['title'] as $key => $value):
                    $title_text = isset($value['title_text']) ? $value['title_text'] : '';
                    $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
                    ?>
                    <div class="pxl-item--inner <?php echo esc_attr($settings['pxl_animate1']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay1']); ?>ms">
                        <div class="pxl-bg-slider">
                            <div class="pxl-item--title">  
                                <?php if ( ! empty( $value['item_link']['url'] ) ) {
                                    $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                                    if ( $value['item_link']['is_external'] ) {
                                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                                    }

                                    if ( $value['item_link']['nofollow'] ) {
                                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                                    }
                                    $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                                    <?php echo pxl_print_html($title_text); ?>
                                    <a <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    </a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>
