<?php
$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-text-scroll pxl-text-scroll2">
    <div class="pxl-meta-inner">
        <div class="pxl-item-left">
            <div class="pxl-item-heading">
                <div class="pxl-sub-title">
                    <?php echo esc_attr($settings['sub_title']); ?>
                </div>
                <div class="pxl-item-title <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <?php echo esc_attr($settings['title']); ?>
                </div>
            </div>
            <div class="pxl-load-title">
                <span class="load pxl-mr-10">
                    <svg class="pxl-scroll-progress-circle" width="100%" height="100%" viewBox="-1 -1 102 102">
                        <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear; stroke-dasharray: 307.919px, 307.919px; stroke-dashoffset: 126.858px;"></path>
                    </svg>
                </span>
                <span class="pxl-title-load">
                    <?php echo esc_attr($settings['title_load']); ?>
                </span>
            </div>
        </div>
        <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
            <div class="pxl-item-right">
                <div class="pxl-list">
                    <?php foreach ($settings['lists'] as $key => $value): ?>
                        <div class="pxl-item">
                            <h5 class="pxl-item-desc">
                                <?php echo pxl_print_html($value['desc'])?>
                            </h5>
                        </div>
                    <?php endforeach; ?>
                </div>
                <div class="barContainer">
                    <div class="bar"></div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>