<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['button_link']['url'] ) ) {
    $widget->add_render_attribute( 'button_link', 'href', $settings['button_link']['url'] );

    if ( $settings['button_link']['is_external'] ) {
        $widget->add_render_attribute( 'button_link', 'target', '_blank' );
    }

    if ( $settings['button_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button_link', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-text-carousel pxl-text-carousel1 pxl-text-slide1 <?php echo esc_attr($settings['style']); ?>">
    <div class="pxl-inner-content">
        <?php if(isset($settings['items']) && !empty($settings['items']) && count($settings['items'])): ?>
            <div class="pxl-text-slide <?php echo esc_attr($settings['effect']); ?>" <?php if(!empty($settings['effect_speed'])) { ?>style="animation-duration:<?php echo esc_attr($settings['effect_speed']); ?>ms"<?php } ?>>
                <?php foreach ($settings['items'] as $key => $value):
                    $text = isset($value['text']) ? $value['text'] : '';
                    if(!empty($text)) : ?>
                        <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <div class="pxl-item--text"><span><?php echo pxl_print_html($text); ?></span></div>
                            <?php if($settings['style'] == 'style2') : ?>
                                <span class="pxl-item--icon pxl-ml-49">
                                    <svg width="120" height="145" viewBox="0 0 120 145" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.923 141.789L100.389 37.3772L103.038 34.2139V38.3404V131.606H118.5V2.375H10.7307V21.4135H88.6154H91.8287L89.7652 23.8767L1.95673 128.698L12.923 141.789Z" stroke="#000" stroke-width="3"/>
                                    </svg>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
            <div class="pxl-text-fixed">
                <?php foreach ($settings['items'] as $key => $value):
                    $text = isset($value['text']) ? $value['text'] : '';
                    if(!empty($text)) : ?>
                        <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <div class="pxl-item--text"><span><?php echo pxl_print_html($text); ?></span></div>
                            <?php if($settings['style'] == 'style2') : ?>
                                <span class="pxl-item--icon pxl-ml-49">
                                    <svg width="120" height="145" viewBox="0 0 120 145" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M12.923 141.789L100.389 37.3772L103.038 34.2139V38.3404V131.606H118.5V2.375H10.7307V21.4135H88.6154H91.8287L89.7652 23.8767L1.95673 128.698L12.923 141.789Z" stroke="#000" stroke-width="3"/>
                                    </svg>
                                </span>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
    <div class="pxl-item-button">
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'button_link' )); ?>><?php } ?>
            <span><?php echo esc_html($settings['title_btn']); ?></span>
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?></a><?php } ?>
    </div>
</div>

