<?php
$html_id = pxl_get_element_id($settings);
$show_star = $widget->get_setting('show_star');
?>
<div class="pxl-testimonial-single pxl-testimonial-single1">
    <div class="pxl-meta-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php if( $show_star == 'true' ) : ?>
            <div class="pxl-inner-star">
                <span class="pxl-item--star pxl-item--<?php echo esc_attr($settings['style_star']); ?>-star">
                    <i class="fa fa-star pxl-mr-4"></i>
                    <i class="fa fa-star pxl-mr-4"></i>
                    <i class="fa fa-star pxl-mr-4"></i>
                    <i class="fa fa-star pxl-mr-4"></i>
                    <i class="fa fa-star pxl-mr-4"></i>
                </span>
            </div>
        <?php endif; ?>
        <div class="pxl-item-desc">
            <?php echo esc_attr($settings['desc']); ?>
        </div>
        <div class="pxl-item-author">
            <?php if(!empty($settings['image']['id'])) : 
                $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '54x54'; 
                $img = pxl_get_image_by_size( array(
                    'attach_id'  => $settings['image']['id'],
                    'thumb_size' => $image_size,
                ));
                $thumbnail = $img['thumbnail'];
                ?>
                <div class="pxl-item--image pxl-mr-16">
                    <?php echo pxl_print_html($thumbnail); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-item-content">
                <div class="pxl-item-title">
                    <?php echo esc_attr($settings['title']); ?>
                </div>
                <div class="pxl-sub-title">
                    <?php echo esc_attr($settings['sub_title']); ?>
                </div>
            </div>
        </div>
    </div>
</div>