<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);  

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); 

?>
<?php if(isset($settings['testimonial_lv3']) && !empty($settings['testimonial_lv3']) && count($settings['testimonial_lv3'])): 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '80x80'; ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel3 pxl-swiper-boxshadow" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'agenzio'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-5">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-long-arrow-right-two"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-long-arrow-right-two"></i></div>
                </div>
            <?php endif; ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial_lv3'] as $key => $value):
                        $title_lv3 = isset($value['title_lv3']) ? $value['title_lv3'] : '';
                        $sub_title_lv3 = isset($value['sub_title_lv3']) ? $value['sub_title_lv3'] : '';
                        $image_lv3 = isset($value['image_lv3']) ? $value['image_lv3'] : '';
                        $desc_lv3 = isset($value['desc_lv3']) ? $value['desc_lv3'] : '';
                        $icon_title1_lv3 = isset($value['icon_title1_lv3']) ? $value['icon_title1_lv3'] : '';
                        $icon_title2_lv3 = isset($value['icon_title2_lv3']) ? $value['icon_title2_lv3'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-item-icon">
                                    <span class="pxl-icon pxl-mr-20">
                                        <svg width="46" height="40" viewBox="0 0 46 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_213_173)">
                                        <path d="M0 19.9998V39.9479H19.7143V19.9998H6.57148C6.57148 12.6671 12.4675 6.70116 19.7143 6.70116V0.0517578C8.84319 0.0517578 0 8.99981 0 19.9998Z" fill="#E44F39"/>
                                        <path d="M46 6.70116V0.0517578C35.1288 0.0517578 26.2856 8.99981 26.2856 19.9998V39.9479H46V19.9998H32.8571C32.8571 12.6671 38.7531 6.70116 46 6.70116Z" fill="#E44F39"/>
                                        </g>
                                        <defs>
                                        <clipPath id="clip0_213_173">
                                        <rect width="46" height="40" fill="white"/>
                                        </clipPath>
                                        </defs>
                                        </svg>
                                    </span>
                                    <span class="pxl-icon-title pxl-icon-title1 pxl-mr-5"><?php echo pxl_print_html($icon_title1_lv3); ?></span>
                                    <span class="pxl-icon-title pxl-icon-title2"><?php echo pxl_print_html($icon_title2_lv3); ?></span>
                                </div>
                                <div class="pxl-item--desc">
                                    <div class="pxl-desc">
                                        <?php echo pxl_print_html($desc_lv3); ?>
                                    </div>

                                    <div class="pxl-svg">
                                        <span class="pxl-svg-no-hover">
                                            <svg width="520" height="32" viewBox="0 0 520 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M520 1H117.5L69.5 31L59.5 1H0" stroke="#DEDEDE"/>
                                            </svg>
                                        </span>
                                        <span class="pxl-svg-hover">
                                            <svg width="520" height="32" viewBox="0 0 520 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M520 1H117.5L69.5 31L59.5 1H0" stroke="#E44F39" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
                                            </svg>
                                        </span>
                                    </div>
                                </div>
                                <div class="pxl-testtiminial-meta">
                                    <div class="pxl-item-layout pxl-mr-20">
                                        <?php if(!empty($image_lv3['id'])) { 
                                            $img = pxl_get_image_by_size( array(
                                                'attach_id'  => $image_lv3['id'],
                                                'thumb_size' => $image_size,
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail = $img['thumbnail'];
                                            ?>
                                            <div class="pxl-item--imgprimary">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="pxl-inner-title">
                                        <h5 class="pxl-item-heading"><?php echo pxl_print_html($title_lv3); ?></h5>
                                        <div class="pxl-sub-title"><?php echo pxl_print_html($sub_title_lv3); ?></div>
                                    </div>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>