<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);  

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'slide', 
    'slides_to_show'                => (int)$col_xl,
    'slides_to_show_xxl'            => (int)$col_xxl, 
    'slides_to_show_lg'             => (int)$col_lg, 
    'slides_to_show_md'             => (int)$col_md, 
    'slides_to_show_sm'             => (int)$col_sm, 
    'slides_to_show_xs'             => (int)$col_xs, 
    'slides_to_scroll'              => (int)$slides_to_scroll,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]); 

?>
<?php if(isset($settings['testimonial_lv2']) && !empty($settings['testimonial_lv2']) && count($settings['testimonial_lv2'])): 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '80x80'; ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel2 pxl-swiper-boxshadow" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'agenzio'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <?php if($arrows !== false): ?>
                <div class="pxl-swiper-arrow-wrap style-5">
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-long-arrow-right-two"></i></div>
                    <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-long-arrow-right-two"></i></div>
                </div>
            <?php endif; ?>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial_lv2'] as $key => $value):
                        $title_lv2 = isset($value['title_lv2']) ? $value['title_lv2'] : '';
                        $desc_lv2 = isset($value['desc_lv2']) ? $value['desc_lv2'] : '';
                        $sub_title_lv2 = isset($value['sub_title_lv2']) ? $value['sub_title_lv2'] : '';
                        $image_lv2 = isset($value['image_lv2']) ? $value['image_lv2'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                <div class="pxl-testtiminial-meta">
                                    <div class="pxl-item--desc"><?php echo pxl_print_html($desc_lv2); ?></div>
                                    <div class="pxl-item-layout">
                                        <?php if(!empty($image_lv2['id'])) { 
                                            $img = pxl_get_image_by_size( array(
                                                'attach_id'  => $image_lv2['id'],
                                                'thumb_size' => $image_size,
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail = $img['thumbnail'];
                                            ?>
                                            <div class="pxl-item--imgprimary pxl-mr-20">
                                                <?php echo wp_kses_post($thumbnail); ?>
                                            </div>
                                        <?php } ?>
                                        <div class="pxl-inner-title">
                                            <h5 class="pxl-item-heading"><?php echo pxl_print_html($title_lv2); ?></h5>
                                            <div class="pxl-sub-title"><?php echo pxl_print_html($sub_title_lv2); ?></div>
                                        </div>
                                    </div>
                                </div>
                           </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
            
        </div>
    </div>
<?php endif; ?>
