<?php
$col_xs = $widget->get_setting('col_xs', '');
$col_sm = $widget->get_setting('col_sm', '');
$col_md = $widget->get_setting('col_md', '');
$col_lg = $widget->get_setting('col_lg', '');
$col_xl = $widget->get_setting('col_xl', '');
$col_xxl = $widget->get_setting('col_xxl', '');
if($col_xxl == 'inherit') {
    $col_xxl = $col_xl;
}
$slides_to_scroll = $widget->get_setting('slides_to_scroll');
$arrows = $widget->get_setting('arrows', false);  
$pagination = $widget->get_setting('pagination', false);
$pagination_type = $widget->get_setting('pagination_type', 'bullets');
$pause_on_hover = $widget->get_setting('pause_on_hover', false);
$autoplay = $widget->get_setting('autoplay', false);
$autoplay_speed = $widget->get_setting('autoplay_speed', 5000);
$infinite = $widget->get_setting('infinite', false);  
$speed = $widget->get_setting('speed', 500);
$drap = $widget->get_setting('drap', false);  

$opts = [
    'slide_direction'               => 'horizontal',
    'slide_percolumn'               => 1, 
    'slide_mode'                    => 'fade', 
    'slides_to_show'                => 1,
    'slides_to_show_xxl'            => 1, 
    'slides_to_show_lg'             => 1, 
    'slides_to_show_md'             => 1, 
    'slides_to_show_sm'             => 1, 
    'slides_to_show_xs'             => 1, 
    'slides_to_scroll'              => 1,
    'arrow'                         => (bool)$arrows,
    'pagination'                    => (bool)$pagination,
    'pagination_type'               => $pagination_type,
    'autoplay'                      => (bool)$autoplay,
    'pause_on_hover'                => (bool)$pause_on_hover,
    'pause_on_interaction'          => true,
    'delay'                         => (int)$autoplay_speed,
    'loop'                          => (bool)$infinite,
    'speed'                         => (int)$speed
];
$widget->add_render_attribute( 'carousel', [
    'class'         => 'pxl-swiper-container',
    'dir'           => is_rtl() ? 'rtl' : 'ltr',
    'data-settings' => wp_json_encode($opts)
]);

$opts_thumb = [
    'slide_direction'               => 'horizontal',
    'slides_to_show'                => 1, 
    'slide_mode'                    => 'fade',
    'loop'                          => false,
];
$widget->add_render_attribute( 'thumb', [
    'class'         => 'pxl-swiper-thumbs',
    'data-settings' => wp_json_encode($opts_thumb)
]);

?>
<?php if(isset($settings['testimonial']) && !empty($settings['testimonial']) && count($settings['testimonial'])):
    $image_size2 = !empty($settings['img_size2']) ? $settings['img_size2'] : '80x80'; 
    $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '850x750'; ?>
    <div class="pxl-swiper-slider pxl-testimonial-carousel pxl-testimonial-carousel1 pxl-swiper-boxshadow"data-view-auto="<?php echo esc_attr($col_xl); ?>" <?php if($drap !== false) : ?>data-cursor-drap="<?php echo esc_html('DRAG', 'agenzio'); ?>"<?php endif; ?>>
        <div class="pxl-carousel-inner">
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'carousel' )); ?>>
                <div class="pxl-swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $title = isset($value['title']) ? $value['title'] : '';
                        $sub_title = isset($value['sub_title']) ? $value['sub_title'] : '';
                        $image_author = isset($value['image_author']) ? $value['image_author'] : '';
                        $desc = isset($value['desc']) ? $value['desc'] : '';
                        $icon_title1 = isset($value['icon_title1']) ? $value['icon_title1'] : '';
                        $icon_title2 = isset($value['icon_title2']) ? $value['icon_title2'] : '';
                        ?>
                        <div class="pxl-swiper-slide">
                            <div class="pxl-item-inner">
                                <div class="pxl-heading px-sub-title-shape2-style pxl-screen-mobile">
                                    <div class="pxl-heading--inner">
                                        <?php if(!empty($settings['wg_sub_title'])) : ?>
                                            <div class="pxl-item--subtitle <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                                                <span class="pxl-item--subtext">
                                                    <?php echo esc_attr($settings['wg_sub_title']); ?>
                                                </span>
                                            </div>
                                        <?php endif; ?>
                                        <?php if(!empty($settings['wg_title'])) : ?>
                                            <h2 class="pxl-item--title wg_title <?php echo esc_attr($settings['pxl_animate2']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay2']); ?>ms">
                                                <span class="pxl-heading--text"><?php echo pxl_print_html($settings['wg_title']); ?></span>
                                            </h2>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="pxl-item-icon <?php echo esc_attr($settings['pxl_animate3']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay3']); ?>ms">
                                    <span class="pxl-icon pxl-mr-20">
                                        <svg width="52" height="40" viewBox="0 0 52 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path d="M16.25 6.67L19.26 0.5H13c-3.35 0-6.47 2.19-8.78 5.38C1.92 9.05 0.5 13.12 0.5 16.67V39.5h21.75V17.17H9.75v-0.5c0-5.12 1.67-7.78 3.45-9.14 0.88-0.67 1.76-1 2.43-1.17 0.33-0.08 0.6-0.11 0.78-0.12zm29.25 0L48.5 0.5H42.25c-3.35 0-6.47 2.19-8.78 5.38C31.17 9.05 29.75 13.12 29.75 16.67V39.5h21.75V17.17H39v-0.5c0-5.12 1.67-7.78 3.45-9.14 0.88-0.67 1.76-1 2.43-1.17 0.33-0.08 0.6-0.11 0.78-0.12z" stroke="#E44F39"/>
                                        </svg>
                                    </span>
                                    <span class="pxl-icon-title pxl-icon-title1 pxl-mr-5"><?php echo pxl_print_html($icon_title1); ?></span>
                                    <span class="pxl-icon-title pxl-icon-title2"><?php echo pxl_print_html($icon_title2); ?></span>
                                </div>
                                <div class="pxl-item--desc">
                                    <div class="pxl-desc <?php echo esc_attr($settings['pxl_animate4']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay4']); ?>ms">
                                        <?php echo pxl_print_html($desc); ?>
                                    </div>

                                    <span class="pxl-svg <?php echo esc_attr($settings['pxl_animate5']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay5']); ?>ms">
                                        <svg width="630" height="32" viewBox="0 0 630 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                          <path class="pxl-path" d="M630 1H117.5L69.5 31L59.5 1H0" stroke="#E44F39" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </span>
                                </div>
                                <div class="pxl-testtiminial-meta <?php echo esc_attr($settings['pxl_animate6']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay6']); ?>ms">
                                    <div class="pxl-item-layout pxl-mr-20">
                                        <?php if(!empty($image_author['id'])) { 
                                            $img_author = pxl_get_image_by_size( array(
                                                'attach_id'  => $image_author['id'],
                                                'thumb_size' => $image_size2,
                                                'class' => 'no-lazyload',
                                            ));
                                            $thumbnail2 = $img_author['thumbnail'];
                                            ?>
                                            <div class="pxl-item--imgprimary">
                                                <?php echo wp_kses_post($thumbnail2); ?>
                                            </div>
                                        <?php } ?>
                                    </div>
                                    <div class="pxl-inner-title">
                                        <h5 class="pxl-item-heading"><?php echo pxl_print_html($title); ?></h5>
                                        <div class="pxl-sub-title"><?php echo pxl_print_html($sub_title); ?></div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
            <div <?php pxl_print_html($widget->get_render_attribute_string( 'thumb' )); ?>>
                <div class="pxl-swiper-wrapper swiper-wrapper">
                    <?php foreach ($settings['testimonial'] as $key => $value):
                        $image = isset($value['image']) ? $value['image'] : '';
                        $link_key = $widget->get_repeater_setting_key( 'link_video', 'value', $key );
                        if ( ! empty( $value['link_video']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['link_video']['url'] );

                            if ( $value['link_video']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['link_video']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key );
                        if($key < 6) : ?>
                            <div class="pxl-swiper-slide swiper-slide">
                                <div class="pxl-item--inner">
                                    <div class="pxl-testtiminial-meta">
                                        <div class="pxl-item-layout">
                                            <?php if(!empty($image['id'])) { 
                                                $img = pxl_get_image_by_size( array(
                                                    'attach_id'  => $image['id'],
                                                    'thumb_size' => $image_size,
                                                    'class' => 'no-lazyload',
                                                ));
                                                $thumbnail = $img['thumbnail'];
                                                ?>
                                                <div class="pxl-item--imgprimary">
                                                    <?php echo wp_kses_post($thumbnail); ?>
                                                </div>
                                            <?php } ?>
                                        </div>
                                        <div class="pxl-inner-video">
                                            <div class="pxl-button-video">
                                                <div class="pxl-item--inner">
                                                    <div class="pxl-item--video">
                                                        <a class="pxl-btn-video pxl-action-popup" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                                            <span><i class="caseicon-play1"></i></span>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <?php if($pagination !== false): ?>
            <div class="pxl-swiper-dots style-1"></div>
        <?php endif; ?>
        <?php if($arrows !== false): ?>
            <div class="pxl-swiper-arrow-wrap style-3">
                <div class="pxl-swiper-arrow pxl-swiper-arrow-prev"><i class="caseicon-long-arrow-right-two"></i></div>
                <div class="pxl-swiper-arrow pxl-swiper-arrow-next"><i class="caseicon-long-arrow-right-two"></i></div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>

