<?php
$html_id = pxl_get_element_id($settings);

if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-team-box pxl-team-box1">
    <div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '720x720'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--img">
                <?php if ( ! empty( $settings['link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>><?php } ?>
                    <?php echo pxl_print_html($thumbnail); ?>
                <?php if ( ! empty( $settings['link']['url'] ) ) { ?></a><?php } ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item-content">
            <div class="pxl-sub-title">
                <?php echo esc_attr($settings['sub_title']); ?>
            </div>
            <?php if ( ! empty( $settings['link']['url'] ) ) { ?><a class="pxl-item-title" <?php pxl_print_html($widget->get_render_attribute_string( 'link' )); ?>><?php } ?>
                <?php echo esc_attr($settings['title']); ?>
            <?php if ( ! empty( $settings['link']['url'] ) ) { ?></a><?php } ?>
        </div>
    </div>
</div>