<?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): 
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : '283x212'; ?>
    <div class="pxl-services-list pxl--services-list1 <?php echo esc_attr($settings['style']); ?>">
        <?php foreach ($settings['lists'] as $key => $value): 
            $title = isset($value['title']) ? $value['title'] : '';
            $image = isset($value['image']) ? $value['image'] : '';
            $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
            if ( ! empty( $value['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                if ( $value['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $value['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); 
            ?>
            <div class="pxl--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                <div class="pxl-item-title">
                    <a class="pxl-item-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                        <?php echo pxl_print_html($title); ?>
                    </a>
                    <?php if(!empty($image['id'])) { 
                        $img = pxl_get_image_by_size( array(
                            'attach_id'  => $image['id'],
                            'thumb_size' => $image_size,
                            'class' => 'no-lazyload',
                        ));
                        $thumbnail = $img['thumbnail'];
                        ?>
                        <div class="pxl-image">
                            <?php echo wp_kses_post($thumbnail); ?>
                        </div>
                    <?php } ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
<?php endif; ?>