<?php
$default_settings = [
    'title' => '',
    'title_gradient' => '',
    'sub_title' => '',
    'desc' => '',
    'button_text' => '',
    'button_link' => '',
    'button_link2' => '',
    'content_monthly' => '',
    'content_year' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);
?>
<div class="pxl-pricing pxl-pricing2">
    <div class="pxl-pricing--top">
        <div class="pxl-content-heading">
            <?php if(!empty($sub_title)) : ?>
                <div class="pxl-item--sub">
                    <?php echo pxl_print_html($sub_title); ?>
                </div>
            <?php endif; ?>
            <?php if(!empty($heading)) : ?>
                <div class="pxl-item--heading <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <span><?php echo pxl_print_html($heading); ?></span>
                </div>
            <?php endif; ?>
        </div>
        <div class="pxl-pricing--nav">
            <?php if(!empty($number)) : ?>
                <span class="pxl-item-number">
                    <?php echo pxl_print_html($number); ?>
                </span>
            <?php endif; ?>
            <span class="pxl-item--navyear"><?php echo esc_html__('Yearly', 'agenzio'); ?></span>
            <div class="pxl-item--nav"></div>
            <span class="pxl-item--navmonthly"><?php echo esc_html__('Monthly', 'agenzio'); ?></span>
        </div>
    </div>
    <div class="pxl-pricing--bottom">
        <?php if(!empty($content_monthly)) : ?>
            <div class="pxl-pricing--body pxl-pricing--monthly">
                <?php foreach ($content_monthly as $key => $value):
                $title = isset($value['title']) ? $value['title'] : '';
                $price = isset($value['price']) ? $value['price'] : '';
                $time = isset($value['time']) ? $value['time'] : '';
                $button_text = isset($value['button_text']) ? $value['button_text'] : '';
                $button_link = isset($value['button_link']) ? $value['button_link'] : '';
                $text1 = isset($value['text1']) ? $value['text1'] : '';
                $text2 = isset($value['text2']) ? $value['text2'] : '';
                $text3 = isset($value['text3']) ? $value['text3'] : '';
                $text4 = isset($value['text4']) ? $value['text4'] : '';
                $text5 = isset($value['text5']) ? $value['text5'] : '';
                $link_key = $widget->get_repeater_setting_key( 'title', 'value', $key );
                if ( ! empty( $button_link['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $button_link['url'] );

                    if ( $button_link['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $button_link['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key );?>
                <div class="pxl-pricing--item">
                    <?php if(!empty($title) || !empty($price) || !empty($time)) : ?>
                        <div class="pxl-pricing--meta">
                            <h6 class="pxl-item--title"><?php echo pxl_print_html($title); ?></h6>
                            <div class="pxl-item-content">
                                <div class="pxl-item--price"><?php echo pxl_print_html($price); ?></div>
                                <div class="pxl-item--time"><?php echo pxl_print_html($time); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <ul class="pxl-pricing--feature">
                        <?php if(!empty($text1)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text1); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text2)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text2); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text3)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text3); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text4)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text4); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text5)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text5); ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php if(!empty($button_text)) : ?>
                        <div class="pxl-item--button">
                            <a class="btn pxl-btn-effect5" <?php echo implode( ' ', [ $link_attributes ] ); ?>><?php echo esc_html($button_text); ?></a>
                        </div>  
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <?php if(!empty($content_year)) : ?>
            <div class="pxl-pricing--body pxl-pricing--year">
                <?php foreach ($content_year as $key => $value):
                $title = isset($value['title']) ? $value['title'] : '';
                $price = isset($value['price']) ? $value['price'] : '';
                $time = isset($value['time']) ? $value['time'] : '';
                $button_text = isset($value['button_text']) ? $value['button_text'] : '';
                $button_link2 = isset($value['button_link2']) ? $value['button_link2'] : '';
                $text1 = isset($value['text1']) ? $value['text1'] : '';
                $text2 = isset($value['text2']) ? $value['text2'] : '';
                $text3 = isset($value['text3']) ? $value['text3'] : '';
                $text4 = isset($value['text4']) ? $value['text4'] : '';
                $text5 = isset($value['text5']) ? $value['text5'] : '';
                $link_key = $widget->get_repeater_setting_key( 'button_link2', 'value', $key );
                if ( ! empty( $value['button_link2']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['button_link2']['url'] );

                    if ( $value['button_link2']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['button_link2']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes2 = $widget->get_render_attribute_string( $link_key ); 

                ?>
                <div class="pxl-pricing--item">
                    <?php if(!empty($title) || !empty($price) || !empty($time)) : ?>
                        <div class="pxl-pricing--meta">
                            <h6 class="pxl-item--title"><?php echo pxl_print_html($title); ?></h6>
                            <div class="pxl-item-content">
                                <div class="pxl-item--price"><?php echo pxl_print_html($price); ?></div>
                                <div class="pxl-item--time"><?php echo pxl_print_html($time); ?></div>
                            </div>
                        </div>
                    <?php endif; ?>
                    <ul class="pxl-pricing--feature">
                        <?php if(!empty($text1)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text1); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text2)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text2); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text3)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text3); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text4)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text4); ?></li>
                        <?php endif; ?>
                        <?php if(!empty($text5)) : ?>
                            <li class="is-active"><i class="caseicon-check"></i><?php echo pxl_print_html($text5); ?></li>
                        <?php endif; ?>
                    </ul>
                    <?php if(!empty($button_text)) : ?>
                        <div class="pxl-item--button">
                            <a class="btn pxl-btn-effect5" <?php echo implode( ' ', [ $link_attributes2 ] ); ?>><?php echo esc_html($button_text); ?></a>
                        </div>  
                    <?php endif; ?>
                </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>