<?php
$active = intval($settings['active']);
$posts = $widget->get_settings('posts');

$html_id = pxl_get_element_id($settings);
$source = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout'] = $settings['layout_'.$settings['post_type']];
$show_excerpt = $widget->get_setting('show_excerpt');
$num_words = $widget->get_setting('num_words');
$show_category = $widget->get_setting('show_category');

extract(pxl_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$img_size = $widget->get_setting('img_size');

?>

<?php if (is_array($posts)): ?>
    <div class="pxl-post-click pxl-portfolio-click1">
        <div class="pxl-post-image-click">
            <div class="pxl-post-image--track">
                <?php $image_size = !empty($img_size) ? $img_size : '600x450';
                    foreach ($posts as $key => $post):

                    $is_active = ($key + 1) == $active;
                    $pxl_id = get_post_meta($post->ID, '_id', true);
                    if (empty($pxl_id)) {
                        $pxl_id = $post->ID; // Fallback to post ID if '_id' is not set.
                    }

                    $client = get_post_meta($post->ID, 'client', true);
                    $total_value = get_post_meta($post->ID, 'total_value', true);
                    $pledge = get_post_meta($post->ID, 'pledge', true);
                    $img_id = get_post_thumbnail_id($post->ID);
                    if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img = pxl_get_image_by_size([
                            'attach_id' => $img_id,
                            'thumb_size' => $image_size
                        ]);
                        $thumbnail = $img['thumbnail'];
                        ?>
                        <div class="pxl-post-item <?php echo esc_attr($is_active ? 'active' : ''); ?>">
                            <div class="pxl-item-post-click" data-target="<?php echo esc_attr('#' . $html_id . '-' . $pxl_id); ?>">
                                <div class="pxl-item-content">
                                    <?php if ($show_category === 'true'): ?>
                                        <div class="pxl-post--category">
                                            <?php the_terms($post->ID, 'portfolio-category', '', ', '); ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="pxl-post--title pxl-empty">
                                         <?php echo pxl_print_html(get_the_title($post->ID)); ?>
                                    </div>
                                </div>
                                
                                <span class="pxl-icon--post"></span>
                            </div>

                            <!-- Toggle visibility based on $is_active -->
                            <div id="<?php echo esc_attr($html_id.'-'.$pxl_id); ?>" class="pxl-item-bottom" <?php if($is_active){ ?>style="display: block;"<?php } ?>>
                                <div class="pxl-inner-meta">
                                    <div class="row">
                                        <div class="col-lg-6 col-md-6 col-sm-12">
                                            <div class="pxl-post--image">
                                                <a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
                                                    <?php echo wp_kses_post($thumbnail); ?>
                                                </a>
                                            </div>
                                        </div>

                                        <div class="col-lg-6 col-md-6 col-sm-12">
                                            <div class="pxl-item-meta">
                                                <?php if ($show_excerpt === 'true'): ?>
                                                    <div class="pxl-item--content pxl-sz-content">
                                                        <?php echo wp_trim_words($post->post_excerpt, $num_words, $more = null); ?>
                                                    </div>
                                                <?php endif; ?>

                                                <div class="pxl-post-list">
                                                    <div class="pxl-item-list client">
                                                        <span class="pxl-item-name"><?php echo esc_html__('client', 'agenzio'); ?></span>
                                                        <?php echo pxl_print_html($client); ?>
                                                    </div>
                                                    
                                                    <div class="pxl-item-list price">
                                                        <span class="pxl-item-name"><?php echo esc_html__('price', 'agenzio'); ?></span>
                                                        <?php echo pxl_print_html($total_value); ?>
                                                    </div>
                                                    
                                                    <div class="pxl-item-list pledge">
                                                        <span class="pxl-item-name"><?php echo esc_html__('application', 'agenzio'); ?></span>
                                                        <?php echo pxl_print_html($pledge); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif;
                endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>