<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link_porfolio']['url'] ) ) {
    $widget->add_render_attribute( 'link_porfolio', 'href', $settings['link_porfolio']['url'] );

    if ( $settings['link_porfolio']['is_external'] ) {
        $widget->add_render_attribute( 'link_porfolio', 'target', '_blank' );
    }

    if ( $settings['link_porfolio']['nofollow'] ) {
        $widget->add_render_attribute( 'link_porfolio', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-porfolio-single pxl-porfolio-single1">
    <div class="pxl-meta-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-categories-button">
            <div class="pxl-item-categories">
                <?php echo esc_attr($settings['categories']); ?>
            </div>
            <div class="pxl-item-button">
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'link_porfolio' )); ?>><?php } ?>
                    <svg width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                        <path d="M1.72308 16L13.5385 4.18462V14.7692H16V0H1.23077V2.46154H11.8154L0 14.2769L1.72308 16Z" fill="#232323"/>
                    </svg>
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?></a><?php } ?>
            </div>
        </div>
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '900x595'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--img">
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'link_porfolio' )); ?>><?php } ?>
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?></a><?php } ?>
                <?php echo pxl_print_html($thumbnail); ?>
            </div>
        <?php endif; ?>
        <div class="pxl-item-content">
            <div class="pxl-item-title pxl-mr-13">
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'link_porfolio' )); ?>><?php } ?>
                    <?php echo esc_attr($settings['title']); ?>
                <?php if ( ! empty( $settings['link_porfolio']['url'] ) ) { ?></a><?php } ?>
            </div>
            <div class="pxl-item-number">
                <?php echo esc_attr($settings['number']); ?>
            </div>
        </div>
        <div class="pxl-item-desc">
            <?php echo esc_attr($settings['desc']); ?>
        </div>
    </div>
</div>