<?php
$html_id = pxl_get_element_id($settings);
$source    = $widget->get_setting('source_'.$settings['post_type']);
$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$post_ids = $widget->get_setting('post_ids', '');
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$img_size = $widget->get_setting('img_size');

?>

<?php if (is_array($posts)): ?>
    <div class="pxl-portfolio-modern pxl-portfolio-modern1 pxl-flex">
        <div class="pxl-portfolio--content">
            <div class="pxl-portfolio--items">
                <?php $image_size = !empty($img_size) ? $img_size : '800x503';
                    foreach ($posts as $key => $post):
                    $img_id       = get_post_thumbnail_id( $post->ID );
                    if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                        $img          = pxl_get_image_by_size( array(
                            'attach_id'  => $img_id,
                            'thumb_size' => $image_size
                        ) );
                        $thumbnail    = $img['thumbnail'];
                        ?>

                        <div class="pxl-portfolio--item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <div class="pxl-content--inner" data-image="#<?php echo esc_attr($html_id.'-'.$key); ?>">
                                <div class="pxl-portfolio--featuredRight">
                                    <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                </div>
                                <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"></a>
                                <div class="pxl-portfolio-min--inner">
                                    <div class="pxl-portfolio--title pxl-empty"><?php echo esc_html(get_the_title($post->ID)); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endif;
                endforeach; ?>
            </div>
            <div class="pxl-portfolio--images">
                <div class="pxl-images--inner <?php echo esc_attr($settings['pxl_animate2']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay2']); ?>ms">
                    <?php $image_size = !empty($img_size) ? $img_size : '850x580';
                        foreach ($posts as $key => $post):
                        $img_id       = get_post_thumbnail_id( $post->ID );
                        if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                            $img          = pxl_get_image_by_size( array(
                                'attach_id'  => $img_id,
                                'thumb_size' => $image_size
                            ) );
                            $thumbnail    = $img['thumbnail'];
                            $thumbnail_url    = $img['url'];
                            ?>
                            <div id="<?php echo esc_attr($html_id.'-'.$key); ?>" class="pxl-portfolio--featured bg-image <?php if($key == '0') { echo 'pxl-portfolio--first active'; } ?>" style="background-image: url(<?php echo esc_url($thumbnail_url); ?>);">
                            </div>
                        <?php endif;
                    endforeach; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>