<?php
$html_id = pxl_get_element_id($settings);
$select_post_by = $widget->get_setting('select_post_by', '');
$source = $post_ids = [];
if($select_post_by === 'post_selected'){
    $post_ids = $widget->get_setting('source_'.$settings['post_type'].'_post_ids', '');
}else{
    $source  = $widget->get_setting('source_'.$settings['post_type'], '');
}

$orderby = $widget->get_setting('orderby', 'date');
$order = $widget->get_setting('order', 'desc');
$limit = $widget->get_setting('limit', 6);
$settings['layout']    = $settings['layout_'.$settings['post_type']];
extract(pxl_get_posts_of_grid('portfolio', [
    'source' => $source,
    'orderby' => $orderby,
    'order' => $order,
    'limit' => $limit,
    'post_ids' => $post_ids,
]));

$show_excerpt = $widget->get_setting('show_excerpt');

?>

<?php if (is_array($posts)): ?>
    <div class="pxl-swiper-sliders pxl-portfolio-click pxl-portfolio-click1 pxl-swiper-boxshadow">
        <div class="pxl-single-inner">
            <div class="pxl-swiper-wrapper">
                <?php
                    $image_size = !empty($img_size) ? $img_size : '800x600';
                    foreach ($posts as $key => $post):
                    $custom_portfolio_number_carousel = get_post_meta($post->ID, 'custom_portfolio_number_carousel', true);
                    ?>
                    <div class="pxl-swiper-single">
                        <div class="pxl-item--inner pxl-not-active <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                            <?php if (has_post_thumbnail($post->ID) && wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), false)): 
                                $img_id       = get_post_thumbnail_id( $post->ID );
                                $img          = pxl_get_image_by_size( array(
                                    'attach_id'  => $img_id,
                                    'thumb_size' => $image_size
                                ) );
                                $thumbnail    = $img['thumbnail']; ?>
                                <div class="pxl-item--image">
                                    <?php echo wp_kses_post($thumbnail); ?>
                                </div>
                            <?php endif; ?>
                            <div class="pxl-item--holder">
                                <div class="pxl-content">
                                    <div class="pxl-item--title">
                                        <a href="<?php echo esc_url(get_permalink($post->ID)); ?>">
                                            
                                        </a>
                                        <?php echo esc_attr(get_the_title($post->ID)); ?>
                                    </div> 
                                    <?php if($show_excerpt == 'true'): ?>
                                        <div class="pxl-post--content">
                                            <?php if($show_excerpt == 'true'): ?>
                                                <?php
                                                echo wp_trim_words( $post->post_excerpt, 12, null );
                                                ?>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <h4 class="pxl-item--number">
                                    <?php if(!empty($custom_portfolio_number_carousel)) { ?>
                                        <?php echo pxl_print_html($custom_portfolio_number_carousel); ?>
                                    <?php } else { ?>
                                        <?php echo pxl_print_html('01'); ?>
                                    <?php } ?>
                                </h4>
                            </div>
                        </div>
                    </div>    
                <?php endforeach; ?>
            </div> 
        </div>
    </div>
<?php endif; ?>