<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['button_link']['url'] ) ) {
    $widget->add_render_attribute( 'button_link', 'href', $settings['button_link']['url'] );

    if ( $settings['button_link']['is_external'] ) {
        $widget->add_render_attribute( 'button_link', 'target', '_blank' );
    }

    if ( $settings['button_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button_link', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-meta pxl-meta1">
    <div class="container">
        <div class="pxl-item-inner">
            <div class="pxl-meta-content">
                <div class="pxl-item-title <?php echo esc_attr($settings['pxl_animate1']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay1']); ?>ms">
                    <?php echo esc_attr($settings['title']); ?>
                </div>
                <div class="pxl-item-desc <?php echo esc_attr($settings['pxl_animate2']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay2']); ?>ms">
                    <?php echo esc_attr($settings['desc']); ?>
                </div>
            </div>
        </div>
    </div>
    <div class="pxl-item-button">
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'button_link' )); ?>><?php } ?>
            <span><?php echo esc_html($settings['title_btn']); ?></span>
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?></a><?php } ?>
    </div>
</div>