<?php if(isset($settings['lists_lv3']) && !empty($settings['lists_lv3']) && count($settings['lists_lv3'])): 
    $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
    <div class="pxl-list-meta pxl-list-meta3 <?php echo esc_attr($settings['style']); ?>">
        <?php foreach ($settings['lists_lv3'] as $key => $value): 
            $icon_key = $widget->get_repeater_setting_key( 'pxl_icon', 'icons', $key );
            $widget->add_render_attribute( $icon_key, [
                'class' => $value['pxl_icon'],
                'aria-hidden' => 'true',
            ] );
            $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
            if ( ! empty( $value['link']['url'] ) ) {
                $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                if ( $value['link']['is_external'] ) {
                    $widget->add_render_attribute( $link_key, 'target', '_blank' );
                }

                if ( $value['link']['nofollow'] ) {
                    $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                }
            }
            $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
            <a class="pxl-item <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                <div class="pxl-item-content">
                	<?php if ( ! empty( $value['pxl_icon'] ) ) : ?>
                        <div class="pxl-item--icon pxl-mr-14">
                            <?php if ( $is_new ):
                                \Elementor\Icons_Manager::render_icon( $value['pxl_icon'], [ 'aria-hidden' => 'true' ] );
                            elseif(!empty($value['pxl_icon'])): ?>
                                <i class="<?php echo esc_attr( $value['pxl_icon'] ); ?>" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <div class="pxl-item--text el-empty">
                        <span><?php echo pxl_print_html($value['text'])?></span>
                    </div>
                </div>
                <div class="pxl-item-arrow">
                	<i class="caseicon-long-arrow-right-two"></i>
                </div>
            </a>
        <?php endforeach; ?>
    </div>
<?php endif; ?>