<?php
$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-language pxl-language1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
    <div class="pxl-meta-inner <?php echo esc_attr($settings['style_list']); ?>">
        <div class="pxl-language-on-off">
            <span class="pxl-language-title pxl-item-title-off">
                <?php echo esc_attr($settings['title_off']); ?>
            </span>
            <span class="pxl-language-title pxl-item-title-on">
                <?php echo esc_attr($settings['title_on']); ?>
            </span>
        </div>
        <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])):
        $is_new = \Elementor\Icons_Manager::is_migration_allowed(); ?>
            <div class="pxl-language-list">
                <div class="pxl-list-inner">
                    <?php foreach ($settings['lists'] as $key => $value):
                        $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                        if ( ! empty( $value['link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                            if ( $value['link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key ); 
                        ?>
                        <div class="pxl-item">
                            <div class="pxl-item--title">
                                <a class="pxl-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <span>
                                        <?php echo pxl_print_html($value['title'])?>
                                    </span>
                                </a>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>