<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['image_link']['url'] ) ) {
    $widget->add_render_attribute( 'image_link', 'href', $settings['image_link']['url'] );

    if ( $settings['image_link']['is_external'] ) {
        $widget->add_render_attribute( 'image_link', 'target', '_blank' );
    }

    if ( $settings['image_link']['nofollow'] ) {
        $widget->add_render_attribute( 'image_link', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-image-author pxl-image-author1">
    <div class="pxl-meta-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '100x100'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--imgprimary">
                <?php if ( ! empty( $settings['image_link']['url'] ) ) { ?><a <?php pxl_print_html($widget->get_render_attribute_string( 'image_link' )); ?>><?php } ?>
                    <?php echo pxl_print_html($thumbnail); ?>
                <?php if ( ! empty( $settings['image_link']['url'] ) ) { ?></a><?php } ?>
            </div>
        <?php endif; ?>
    </div>
</div>