<?php
$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-icon-box pxl-icon-box1">
	<div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate1']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay1']); ?>ms">
		<div class="pxl-meta-content">
			<span class="pxl-item-number">
				<?php echo esc_attr($settings['number']); ?>
			</span>
			<?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
				<div class="pxl-icon-wrap">
					<div class="pxl-item--icon pxl-mr-49">
	                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
	                </div>
				</div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon pxl-mr-49">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
			<div class="content-inner">
				<h5 class="pxl-item-title">
	            	<?php echo esc_attr($settings['title']); ?>
	            </h5>
				<div class="pxl-item-desc">
					<?php echo esc_attr($settings['desc']); ?>
				</div>
			</div>
		</div>
	</div>
</div>