<?php 
if ( ! empty( $settings['video_link']['url'] ) ) {
    $widget->add_render_attribute( 'video_link', 'href', $settings['video_link']['url'] );

    if ( $settings['video_link']['is_external'] ) {
        $widget->add_render_attribute( 'video_link', 'target', '_blank' );
    }

    if ( $settings['video_link']['nofollow'] ) {
        $widget->add_render_attribute( 'video_link', 'rel', 'nofollow' );
    }
}
$html_id = pxl_get_element_id($settings); 
if($settings['button_effect'] == 'pxl-image-parallax') { wp_enqueue_script( 'pxl-parallax-move-mouse'); }
?>
<div id="<?php echo esc_attr($html_id) ?>" class="pxl-button-video pxl-button-video1 <?php if(!empty($settings['button_effect'])) { echo esc_attr($settings['button_effect']); } ?> <?php echo esc_attr($settings['style'].' '.$settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" <?php if($settings['button_effect'] == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?>>
    <div class="pxl-item--inner <?php if($settings['style'] == 'style-divider') : ?>wow<?php endif;?>" data-wow-delay="120ms">
        <div class="pxl-item--video pxl-item--image pxl-mr-22" data-parallax-value="<?php echo esc_attr($settings['parallax_value']); ?>">
            <?php if ( ! empty( $settings['video_link']['url'] ) ) { ?><a class="pxl-btn-video pxl-action-popup" <?php pxl_print_html($widget->get_render_attribute_string( 'video_link' )); ?>><?php } ?>
                <span><i class="caseicon-play1"></i></span>
            <?php if ( ! empty( $settings['video_link']['url'] ) ) { ?></a><?php } ?>
        </div>
        <div class="pxl-content">
            <div class="pxl-item-title">
                <?php echo esc_attr($settings['title']); ?>
            </div>
        </div>
    </div>
</div>