<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_button', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_button', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_button', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-button-meta pxl-button-meta1">
	<div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate1']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay1']); ?>ms">
		<div class="pxl-meta-content">
            <a class="pxl-item-title" <?php pxl_print_html($widget->get_render_attribute_string( 'link_button' )); ?>>
                <?php echo esc_attr($settings['title']); ?>
            </a>
		</div>
	</div>
</div>