<?php 
if ( ! empty( $settings['button_link']['url'] ) ) {
    $widget->add_render_attribute( 'button_link', 'href', $settings['button_link']['url'] );

    if ( $settings['button_link']['is_external'] ) {
        $widget->add_render_attribute( 'button_link', 'target', '_blank' );
    }

    if ( $settings['button_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button_link', 'rel', 'nofollow' );
    }
}
$html_id = pxl_get_element_id($settings); 
if($settings['button_effect'] == 'pxl-image-parallax') { wp_enqueue_script( 'pxl-parallax-move-mouse'); }
?>
<div id="<?php echo esc_attr($html_id) ?>" class="pxl-button-custom pxl-button-custom1 pxl-image-parallax <?php echo esc_attr($settings['style']); ?> <?php if(!empty($settings['button_effect'])) { echo esc_attr($settings['button_effect']); } ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" <?php if($settings['button_effect'] == 'pxl-image-tilt') : ?>data-maxtilt="<?php echo esc_attr($settings['max_tilt']); ?>" data-speedtilt="<?php echo esc_attr($settings['speed_tilt']); ?>" data-perspectivetilt="<?php echo esc_attr($settings['perspective_tilt']); ?>"<?php endif; ?> <?php if($settings['button_effect'] == 'pxl-parallax-scroll') : ?>data-parallax='{"<?php echo esc_attr($settings['parallax_scroll_type']); ?>":<?php echo esc_attr($settings['parallax_scroll_value_x']); ?>}'<?php endif; ?>>

    <div class="pxl-item-inner <?php if($settings['style'] == 'style-divider') : ?>wow<?php endif;?>" data-wow-delay="120ms">
        <div class="pxl-item--image" data-parallax-value="<?php echo esc_attr($settings['parallax_value']); ?>">
            <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?><a class="pxl-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'button_link' )); ?>><?php } ?>
                <span><?php echo esc_html($settings['title']); ?></span>
            <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?></a><?php } ?>
        </div>
    </div>
</div>