<?php
$widget->add_render_attribute( 'pxl_team_wrap', 'id', pxl_get_element_id($settings));
$widget->add_render_attribute( 'pxl_team_wrap', 'class', 'pxl-image-wg');
$widget->add_render_attribute( 'pxl_team_wrap', 'duration', '1');
if(!empty($settings['custom_style']))
    $widget->add_render_attribute( 'pxl_team_wrap', 'class', $settings['custom_style']);

if(!empty($settings['pxl_parallax'])){
    $parallax_settings = json_encode([
        $settings['pxl_parallax'] => $settings['parallax_value']
    ]);
    $widget->add_render_attribute( 'pxl_team_wrap', 'data-parallax', $parallax_settings );
}

$html_id = pxl_get_element_id($settings);
?>
<div class="pxl-banner-box pxl-banner-box1">
    <div class="pxl-meta-inner">
        <?php if(!empty($settings['image']['id'])) : 
            $image_size = !empty($settings['img_size']) ? $settings['img_size'] : '900x1080'; 
            $img = pxl_get_image_by_size( array(
                'attach_id'  => $settings['image']['id'],
                'thumb_size' => $image_size,
            ));
            $thumbnail = $img['thumbnail'];
            ?>
            <div class="pxl-item--imgprimary">
                <div class="pxl-img1 <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
                    <?php echo pxl_print_html($thumbnail); ?>
                </div>
                <div class="pxl-item-svg <?php echo esc_attr($settings['pxl_animate3']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay3']); ?>ms">
                    <div <?php pxl_print_html($widget->get_render_attribute_string( 'pxl_team_wrap' )); ?>>
                        <svg width="50" height="50" viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg">
                          <g clip-path="url(#clip0_71_136)">
                            <path d="M45.0835 18.9808L31.0191 4.91629C30.507 4.40418 29.7206 4.28972 29.0839 4.63465C24.4305 7.15427 20.235 10.6621 16.9557 14.7719C14.51 17.8064 12.542 21.1646 11.1056 24.7548C10.6216 25.9703 10.2131 27.2051 9.85798 28.4358L4.61131 31.5776C4.17899 31.8368 3.89002 32.2802 3.8282 32.7801C3.76649 33.2806 3.93895 33.781 4.2951 34.137L6.71921 36.5611C5.08221 38.6876 2.44393 42.7068 2.43934 45.0249C2.43719 45.9613 2.81883 46.5399 3.13944 46.8605C3.45887 47.1806 4.03543 47.5606 4.96766 47.5606C4.9698 47.5606 4.97244 47.5606 4.97508 47.5606C7.29324 47.556 11.3125 44.9178 13.4388 43.2808L15.8629 45.7049C16.1711 46.0137 16.5879 46.1841 17.0192 46.1841C17.0857 46.1841 17.1529 46.1798 17.2199 46.1719C17.7198 46.1102 18.1632 45.821 18.4224 45.3888L21.5644 40.1418C22.7959 39.7878 24.0352 39.3757 25.2559 38.8833C28.8558 37.4501 32.2113 35.4853 35.2217 33.0491C39.3379 29.765 42.8457 25.5694 45.3653 20.9161C45.7101 20.2792 45.595 19.4924 45.0835 18.9808ZM16.6932 41.9096L8.09031 33.3067L10.9864 31.5723L18.4278 39.0137L16.6932 41.9096ZM33.2093 26.0414C31.9753 27.276 30.3323 27.9553 28.5836 27.9553C26.8348 27.9553 25.1924 27.2761 23.9584 26.0419C23.9584 26.0413 23.9584 26.0413 23.9584 26.0413C23.9584 26.0413 23.9584 26.0413 23.9579 26.0413C22.7239 24.8074 22.0445 23.165 22.0445 21.4162C22.0445 19.6673 22.7238 18.0246 23.9583 16.7905C26.5089 14.2399 30.6586 14.2404 33.2092 16.7899C35.7598 19.3417 35.7598 23.4914 33.2093 26.0414Z" fill="#000"/>
                            <path d="M48.5424 1.4574C47.5107 0.42449 46.0871 -0.0976774 44.6391 0.0151154C40.7522 0.319412 36.9801 1.20701 33.3692 2.64089L47.3587 16.6304C48.7922 13.0205 49.6797 9.24957 49.984 5.36374C50.1006 3.91374 49.5751 2.48962 48.5424 1.4574Z" fill="#000"/>
                            <path d="M26.4657 41.9217C25.3561 42.3694 24.2258 42.7497 23.0955 43.095C22.8432 44.6504 22.3754 46.1951 21.6792 47.6642C21.3832 48.2882 21.5115 49.0308 21.9996 49.5196C22.3132 49.8343 22.7321 49.9998 23.1575 49.9998C23.3933 49.9998 23.6319 49.9486 23.8548 49.8432C26.0311 48.8169 28.011 47.4258 29.7428 45.7047C32.1421 43.306 33.8851 40.4575 34.8795 37.3887C32.2648 39.2108 29.4448 40.7357 26.4657 41.9217Z" fill="#000"/>
                            <path d="M4.2913 20.2606C2.57392 21.9887 1.18281 23.9685 0.156446 26.1449C-0.138476 26.7698 -0.008593 27.513 0.480664 28.0006C0.794237 28.3136 1.21211 28.4781 1.63594 28.4781C1.87343 28.4781 2.11347 28.4265 2.33759 28.3196C3.80624 27.6213 5.35028 27.1532 6.90536 26.9026C7.2494 25.776 7.62635 24.6511 8.06678 23.5449C9.25604 20.5721 10.7846 17.7511 12.6171 15.1189C9.54598 16.113 6.69442 17.8575 4.2913 20.2606Z" fill="#000"/>
                          </g>
                          <defs>
                            <clipPath id="clip0_71_136">
                              <rect width="50" height="50" fill="#000"/>
                            </clipPath>
                          </defs>
                        </svg>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        <?php if(!empty($settings['banner_image2']['id'])) : 
            $image_size2 = !empty($settings['img_size2']) ? $settings['img_size2'] : '1000x1120'; 
            $img_2 = pxl_get_image_by_size( array(
                'attach_id'  => $settings['banner_image2']['id'],
                'thumb_size' => $image_size2,
            ));
            $thumbnail_2 = $img_2['thumbnail']; ?>
            <div class="pxl-item--imgsecondary">
                <span class="pxl-item-svg2">
                    <svg width="165" height="117" viewBox="0 0 165 117" xmlns="http://www.w3.org/2000/svg">
                    <path d="M159.333 3C159.333 4.47276 160.527 5.66667 162 5.66667C163.473 5.66667 164.667 4.47276 164.667 3C164.667 1.52724 163.473 0.333333 162 0.333333C160.527 0.333333 159.333 1.52724 159.333 3ZM109.5 63.5L109.223 63.0836L109.5 63.5ZM33.5 88.5L33.2283 88.0803L33.5 88.5ZM1 116.5C1.35787 116.849 1.35786 116.849 1.35786 116.849C1.35787 116.849 1.35787 116.849 1.35788 116.849C1.35789 116.849 1.35792 116.849 1.35795 116.849C1.35802 116.849 1.35814 116.849 1.35829 116.849C1.3586 116.848 1.35908 116.848 1.35972 116.847C1.361 116.846 1.36294 116.844 1.36554 116.841C1.37075 116.836 1.37858 116.828 1.38901 116.817C1.40986 116.796 1.44108 116.764 1.48234 116.722C1.56487 116.638 1.68758 116.514 1.84793 116.352C2.16864 116.028 2.63989 115.554 3.2413 114.957L2.53655 114.247C1.93301 114.847 1.4598 115.322 1.13728 115.648C0.976018 115.811 0.852428 115.936 0.769056 116.021C0.72737 116.064 0.695738 116.096 0.674478 116.118C0.663848 116.129 0.655812 116.137 0.650408 116.142C0.647706 116.145 0.645662 116.147 0.644282 116.149C0.643591 116.149 0.643067 116.15 0.642709 116.15C0.64253 116.15 0.642393 116.151 0.642297 116.151C0.642249 116.151 0.642211 116.151 0.642184 116.151C0.642171 116.151 0.642158 116.151 0.642152 116.151C0.642142 116.151 0.642135 116.151 1 116.5ZM7.08003 111.208C8.24901 110.084 9.55974 108.841 10.9764 107.522L10.2949 106.79C8.87402 108.113 7.55944 109.36 6.38711 110.487L7.08003 111.208ZM14.9328 103.9C16.2297 102.733 17.5768 101.543 18.9541 100.354L18.3006 99.5969C16.9176 100.791 15.5654 101.986 14.2641 103.156L14.9328 103.9ZM23.0526 96.9001C24.4465 95.7561 25.8503 94.6374 27.2451 93.5676L26.6365 92.7741C25.2318 93.8515 23.8193 94.9772 22.4182 96.127L23.0526 96.9001ZM31.5604 90.4055C32.3077 89.8862 33.0459 89.3896 33.7717 88.9197L33.2283 88.0803C32.4924 88.5567 31.7451 89.0594 30.9898 89.5843L31.5604 90.4055ZM33.7717 88.9197C34.4838 88.4587 35.1939 88.0173 35.9023 87.5942L35.3896 86.7357C34.6709 87.1649 33.9505 87.6127 33.2283 88.0803L33.7717 88.9197ZM40.2952 85.1868C41.8209 84.4232 43.3395 83.7361 44.8519 83.1145L44.4718 82.1896C42.9373 82.8203 41.3962 83.5175 39.8476 84.2925L40.2952 85.1868ZM49.548 81.3766C51.1545 80.8443 52.7557 80.3736 54.3529 79.9512L54.0973 78.9844C52.4822 79.4115 50.8612 79.888 49.2334 80.4274L49.548 81.3766ZM59.2361 78.7936C60.8834 78.4437 62.5278 78.1308 64.1714 77.8399L63.9971 76.8552C62.3452 77.1476 60.6893 77.4627 59.0284 77.8155L59.2361 78.7936ZM69.1384 77.0117C70.7945 76.7476 72.4632 76.4884 74.1213 76.2226L73.963 75.2352C72.3 75.5018 70.6479 75.7583 68.9809 76.0241L69.1384 77.0117ZM79.1047 75.3832C80.7566 75.0865 82.4118 74.7659 84.071 74.4061L83.8591 73.4288C82.2141 73.7855 80.571 74.1038 78.9279 74.3989L79.1047 75.3832ZM88.9968 73.2117C90.6096 72.7747 92.2275 72.287 93.8513 71.7348L93.5293 70.788C91.9273 71.3329 90.3298 71.8145 88.7353 72.2465L88.9968 73.2117ZM98.5982 69.9311C100.126 69.2861 101.66 68.5731 103.201 67.781L102.744 66.8916C101.226 67.6719 99.7151 68.3742 98.2093 69.0098L98.5982 69.9311ZM107.632 65.287C108.345 64.8494 109.06 64.3929 109.777 63.9164L109.223 63.0836C108.517 63.5534 107.812 64.0033 107.109 64.4346L107.632 65.287ZM109.777 63.9164C110.471 63.4548 111.165 62.9751 111.859 62.4787L111.277 61.6655C110.592 62.1555 109.907 62.6287 109.223 63.0836L109.777 63.9164ZM115.886 59.4115C117.181 58.3675 118.471 57.2732 119.753 56.1372L119.089 55.3888C117.818 56.5154 116.54 57.5996 115.258 58.633L115.886 59.4115ZM123.468 52.7117C124.677 51.5544 125.876 50.3663 127.062 49.1549L126.347 48.4553C125.168 49.6596 123.977 50.84 122.776 51.9893L123.468 52.7117ZM130.543 45.4952C131.688 44.2589 132.817 43.0069 133.928 41.7463L133.178 41.0851C132.072 42.34 130.948 43.5859 129.81 44.8158L130.543 45.4952ZM137.225 37.921C138.32 36.6232 139.393 35.3239 140.441 34.0308L139.664 33.401C138.62 34.6894 137.551 35.9837 136.461 37.2762L137.225 37.921ZM143.584 30.0812C144.642 28.7273 145.669 27.3893 146.661 26.0762L145.863 25.4735C144.874 26.7824 143.851 28.1161 142.796 29.4654L143.584 30.0812ZM149.667 22.0311C150.699 20.6191 151.683 19.2511 152.612 17.9404L151.796 17.3621C150.87 18.669 149.889 20.033 148.86 21.4408L149.667 22.0311ZM155.497 13.8047C156.551 12.2711 157.501 10.8616 158.335 9.60605L157.502 9.05249C156.671 10.3041 155.724 11.7094 154.673 13.2385L155.497 13.8047ZM161.091 5.3822C161.525 4.70316 161.858 4.17351 162.084 3.81332C162.196 3.63323 162.282 3.4955 162.339 3.40264C162.368 3.35621 162.39 3.32099 162.404 3.29731C162.411 3.28547 162.417 3.27651 162.421 3.27048C162.423 3.26746 162.424 3.26517 162.425 3.26362C162.425 3.26284 162.426 3.26225 162.426 3.26184C162.426 3.26164 162.426 3.26148 162.426 3.26137C162.426 3.26132 162.426 3.26127 162.426 3.26124C162.426 3.26122 162.426 3.26121 162.426 3.2612C162.426 3.26118 162.426 3.26117 162 3C161.574 2.73883 161.574 2.73882 161.574 2.73882C161.574 2.73882 161.574 2.73882 161.574 2.73883C161.574 2.73884 161.574 2.73887 161.574 2.73891C161.574 2.73898 161.573 2.7391 161.573 2.73926C161.573 2.7396 161.573 2.74011 161.572 2.74081C161.572 2.74221 161.57 2.74434 161.568 2.74721C161.565 2.75293 161.56 2.76158 161.553 2.77311C161.538 2.79616 161.517 2.83074 161.489 2.87653C161.432 2.96811 161.347 3.10453 161.236 3.28329C161.012 3.64079 160.681 4.16762 160.248 4.84372L161.091 5.3822Z" fill="#DEDEDE"/>
                    </svg>
                </span>
                <div class="pxl-img2 <?php echo esc_attr($settings['pxl_animate2']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay2']); ?>ms">
                    <?php echo pxl_print_html($thumbnail_2); ?>
                </div>
                <span class="pxl-item-svg3">
                    <svg width="214" height="171" viewBox="0 0 214 171" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M213.5 1C213.5 1 181.38 109.2 136.5 99C125.5 96.5 114.458 87.5636 110 68.5C105.831 50.67 111.5 33.9042 127.5 25C145.903 14.7589 165.381 24.936 179 41C186.18 49.4686 187.989 56.1851 190.5 67C198.566 101.743 180.896 127.662 153.5 150.5C123.29 175.685 54.5 169 54.5 169L1 162.5" stroke="#DEDEDE" stroke-dasharray="5 5"/>
                    </svg>
                </span>
            </div>
        <?php endif; ?>
        <div class="pxl-item-title <?php echo esc_attr($settings['pxl_animate4']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay4']); ?>ms">
            <?php echo esc_attr($settings['title']); ?>
        </div>
    </div>
</div>