<?php
$html_id = pxl_get_element_id($settings);

if ( ! empty( $settings['link_title']['url'] ) ) {
    $widget->add_render_attribute( 'link_title', 'href', $settings['link_title']['url'] );

    if ( $settings['link_title']['is_external'] ) {
        $widget->add_render_attribute( 'link_title', 'target', '_blank' );
    }

    if ( $settings['link_title']['nofollow'] ) {
        $widget->add_render_attribute( 'link_title', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-awardes pxl-awardes1">
    <div class="pxl-item-inner <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-item-content">
            <div class="pxl-content-title">
                <?php echo esc_attr($settings['title']); ?>
            </div>
            <div class="pxl-item-btn">
                <?php echo esc_attr($settings['title_btn']); ?>
                <svg class="pxl-ml-11" width="16" height="16" viewBox="0 0 16 16" xmlns="http://www.w3.org/2000/svg">
                    <path d="M1.72308 16L13.5385 4.18462V14.7692H16V0H1.23077V2.46154H11.8154L0 14.2769L1.72308 16Z" fill="#232323"/>
                </svg>
            </div>
        </div>
        <div class="pxl-content-hover">
            <div class="pxl-title-hover">
                <?php if ( ! empty( $settings['link_title']['url'] ) ) { ?><a class="pxl-item-title" <?php pxl_print_html($widget->get_render_attribute_string( 'link_title' )); ?>><?php } ?>
                    <?php echo esc_attr($settings['title']); ?>
                <?php if ( ! empty( $settings['link_title']['url'] ) ) { ?></a><?php } ?>
            </div>
            <?php if(isset($settings['lists']) && !empty($settings['lists']) && count($settings['lists'])): ?>
                <div class="pxl-list">
                    <?php foreach ($settings['lists'] as $key => $value): 
                        $link_key = $widget->get_repeater_setting_key( 'link', 'value', $key );
                        if ( ! empty( $value['link']['url'] ) ) {
                            $widget->add_render_attribute( $link_key, 'href', $value['link']['url'] );

                            if ( $value['link']['is_external'] ) {
                                $widget->add_render_attribute( $link_key, 'target', '_blank' );
                            }

                            if ( $value['link']['nofollow'] ) {
                                $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                            }
                        }
                        $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                        <div class="pxl--item">
                            <a class="pxl-item-link" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                <span><?php echo pxl_print_html($value['text'])?></span>
                            </a>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>