<?php
/**
 * @package Case-Themes
 */

if ( post_password_required() ) {
    return;
    } ?>

    <div id="comments" class="comments-area">

        <?php
        if ( have_comments() ) : ?>
            <div class="comment-list-wrap">

                <h2 class="comments-title">
                    <?php
                        $comment_count = get_comments_number();
                        if ( 1 === intval($comment_count) ) {
                            echo esc_html__( '1 Comment', 'agenzio' );
                        } else {
                            echo esc_attr( $comment_count ).' '.esc_html__('Comments', 'agenzio');
                        }
                    ?>
                </h2>

                <?php the_comments_navigation(); ?>

                <ul class="comment-list">
                    <?php
                        wp_list_comments( array(
                            'style'      => 'ul',
                            'short_ping' => true,
                            'callback'   => 'agenzio_comment_list',
                            'max_depth'  => 3
                        ) );
                    ?>
                </ul>

                <?php the_comments_navigation(); ?>
            </div>
            <?php if ( ! comments_open() ) : ?>
                <p class="no-comments"><?php esc_html_e( 'Comments are closed.', 'agenzio' ); ?></p>
            <?php
            endif;

        endif;

        // Định nghĩa HTML cho đánh giá
        $rating_html = '<div class="comment-form-rating">
            <span class="star-rating">
                <span class="star1">
                    <input type="radio" id="star1" name="rating" value="1" data-value="1">
                    <label for="star1" data-value="1"><i class="far fa-star" aria-hidden="true"></i></label>
                </span>
                <span class="star2">
                    <input type="radio" id="star2" name="rating" value="2" data-value="2">
                    <label for="star2" data-value="2"><i class="far fa-star" aria-hidden="true"></i></label>
                </span>
                <span class="star3">
                    <input type="radio" id="star3" name="rating" value="3" data-value="3">
                    <label for="star3" data-value="3"><i class="far fa-star" aria-hidden="true"></i></label>
                </span>
                <span class="star4">
                    <input type="radio" id="star4" name="rating" value="4" data-value="4">
                    <label for="star4" data-value="4"><i class="far fa-star" aria-hidden="true"></i></label>
                </span>
                <span class="star5">
                    <input type="radio" id="star5" name="rating" value="5" data-value="5">
                    <label for="star5" data-value="5"><i class="far fa-star" aria-hidden="true"></i></label>
                </span>
            </span>
        </div>';

        $args = array(
            'id_form'           => 'commentform',
            'id_submit'         => 'submit',
            'class_submit'      => 'btn-form-submit',
            'title_reply'       => esc_attr__( 'Leave A Comment', 'agenzio'),
            'title_reply_to'    => esc_attr__( 'Leave A Comment To ', 'agenzio') . '%s',
            'cancel_reply_link' => esc_attr__( 'Cancel Comment', 'agenzio'),
            'submit_button'     => '<button name="%1$s" type="submit" id="%2$s" class="%3$s">%4$s <i class="pxl-icon"></i></button>',
            'comment_notes_before' => '',
            'fields' => apply_filters( 'comment_form_default_fields', array(
                'author' => '<div class="container"><div class="row"><div class="comment-form-author comment-input col-12 col-lg-4">'.
                            '<svg width="13" height="14" viewBox="0 0 13 14" xmlns="http://www.w3.org/2000/svg">
                            <g id="Icon">
                            <path id="user" d="M6.125 7C4.18359 7 2.625 5.44141 2.625 3.5C2.625 1.58594 4.18359 0 6.125 0C8.03906 0 9.625 1.58594 9.625 3.5C9.625 5.44141 8.03906 7 6.125 7ZM8.55859 7.875C10.582 7.875 12.25 9.54297 12.25 11.5664V12.6875C12.25 13.4258 11.6484 14 10.9375 14H1.3125C0.574219 14 0 13.4258 0 12.6875V11.5664C0 9.54297 1.64062 7.875 3.66406 7.875H4.12891C4.73047 8.17578 5.41406 8.3125 6.125 8.3125C6.83594 8.3125 7.49219 8.17578 8.09375 7.875H8.55859Z" fill="#232323"/>
                            </g>
                            </svg>'.
                            '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) .
                            '" size="30" placeholder="'.esc_attr__('Your name', 'agenzio').'"/></div>',
                'email' => '<div class="comment-form-email comment-input col-12 col-lg-4">'.
                            '<svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                            <g id="Icon">
                            <path id="envelope-open" d="M14 12.6743C14 13.4125 13.3984 13.9868 12.6875 13.9868H1.3125C0.574219 13.9868 0 13.4125 0 12.6743V5.48284C0 5.07269 0.191406 4.68988 0.492188 4.44378C1.17578 3.92425 1.72266 3.48675 4.97656 1.13519C5.44141 0.807064 6.34375 -0.0132487 7 0.014095C7.62891 -0.0132487 8.53125 0.807064 8.99609 1.13519C12.25 3.48675 12.7969 3.92425 13.4805 4.44378C13.7812 4.68988 14 5.07269 14 5.48284V12.6743ZM12.1953 7.31488C12.1133 7.2055 11.9766 7.17816 11.8672 7.26019C11.2656 7.72503 10.3633 8.38128 8.99609 9.36566C8.53125 9.69378 7.62891 10.5141 7 10.4868C6.34375 10.5141 5.44141 9.69378 4.97656 9.36566C3.60938 8.38128 2.70703 7.72503 2.10547 7.26019C1.99609 7.17816 1.85938 7.2055 1.77734 7.31488L1.53125 7.67034C1.50391 7.69769 1.50391 7.75238 1.50391 7.80706C1.50391 7.86175 1.53125 7.94378 1.58594 7.97113C2.21484 8.43597 3.08984 9.09222 4.45703 10.0766C5.03125 10.4868 6.01562 11.3891 7 11.3618C7.95703 11.3891 8.94141 10.4868 9.51562 10.0766C10.8828 9.09222 11.7578 8.43597 12.3867 7.97113C12.4414 7.94378 12.4688 7.86175 12.4688 7.80706C12.4688 7.75238 12.4688 7.69769 12.4414 7.67034L12.1953 7.31488Z" fill="#232323"/>
                            </g>
                            </svg>'.
                           '<input id="email" name="email" type="text" value="' . esc_attr( $commenter['comment_author_email'] ) .
                           '" size="30" placeholder="'.esc_attr__('info@', 'agenzio').'"/></div>',
                'phone' => '<div class="comment-form-phone comment-input col-12 col-lg-4">'.
                            '<svg width="15" height="14" viewBox="0 0 15 14" xmlns="http://www.w3.org/2000/svg">
                            <path id="phone" d="M13.4923 0.680468C13.793 0.7625 14.0118 1.00859 14.0118 1.30937C14.0118 8.33672 8.3243 13.9969 1.3243 13.9969C0.996175 13.9969 0.750081 13.8055 0.66805 13.5047L0.0117997 10.6609C-0.0428878 10.3602 0.093831 10.032 0.394612 9.89531L3.45711 8.58281C3.73055 8.47344 4.03133 8.55547 4.22274 8.77422L5.58992 10.4422C7.72274 9.43047 9.44539 7.68047 10.4298 5.60234L8.7618 4.23516C8.54305 4.04375 8.46102 3.74297 8.57039 3.46953L9.88289 0.407031C10.0196 0.10625 10.3477 -0.0578128 10.6485 0.0242184L13.4923 0.680468Z" fill="#232323"/>
                            </svg>'.
                           '<input id="phone" name="phone" type="text" value="" size="30" placeholder="'.esc_attr__('Phone number', 'agenzio').'"/></div></div></div>',
            )),
            'comment_field' => '<div class="comment-form-comment">'.
                                '<svg width="14" height="14" viewBox="0 0 14 14" xmlns="http://www.w3.org/2000/svg">
                                <path id="pen" d="M7.93527 2.55737L11.4353 6.05737L3.8337 13.6589L0.716516 13.9871C0.30636 14.0417 -0.0491086 13.6863 0.00557892 13.2761L0.333704 10.1589L7.93527 2.55737ZM13.5954 2.03784C14.115 2.53003 14.115 3.37769 13.5954 3.89722L12.0642 5.42847L8.56417 1.92847L10.0954 0.397217C10.615 -0.122314 11.4626 -0.122314 11.9548 0.397217L13.5954 2.03784Z" fill="#232323"/>
                                </svg>'.
                              '<textarea id="comment" name="comment" cols="45" rows="8" placeholder="'.esc_attr__('Message', 'agenzio').'" aria-required="true"></textarea>'.
                              '</div>' . $rating_html,
        );
        comment_form($args);
        ?>
</div>