<html>
<?php
include('config.php');
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $errors = [];

    // Required fields (photo is in $_FILES)
    $requiredFields = ['naam', 'dayitva', 'father_name', 'mobileno', 'district_id', 'loksabha_id', 'vidhan_id', 'mandal_id', 'booth_id', 'address'];
    foreach ($requiredFields as $field) {
        if (empty($_POST[$field])) {
            $errors[] = ucfirst(str_replace('_', ' ', $field)) . " is required.";
        }
    }

    // Photo must be uploaded
    if (!isset($_FILES['photo']) || empty($_FILES['photo']['name'])) {
        $errors[] = "Photo is required.";
    }

    // Check if mobile number already exists
    if (empty($errors)) {
        $existing = $db->getVal("SELECT id FROM volunteer WHERE mobileno = '" . $db->escape($_POST['mobileno']) . "'");
        if ($existing != "") {
            $errors[] = "Mobile Number is already registered. Please use a different number.";
        }
    }

    // Process photo upload if no errors so far
    if (empty($errors) && isset($_FILES['photo']['name']) && !empty($_FILES['photo']['name'])) {
        $filename = basename($_FILES['photo']['name']);
        $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
        if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'svg', 'webp'])) {
            $newphoto = date("YmdHis") . rand(1000, 9999) . "." . $ext;
            if (!move_uploaded_file($_FILES['photo']['tmp_name'], "uploads/" . $newphoto)) {
                $errors[] = "Failed to upload photo.";
            }
        } else {
            $errors[] = "Invalid photo format. Allowed: jpg, jpeg, png, gif, svg, webp.";
        }
    }

    if (empty($errors)) {
        // Insert data into the database
        $aryData = [
            'token' => token('volunteer'),
            'naam' => $_POST['naam'],
            'dayitva' => $_POST['dayitva'],
            'father_name' => $_POST['father_name'],
            'mobileno' => $_POST['mobileno'],
            'district_id' => $_POST['district_id'],
            'loksabha_id' => $_POST['loksabha_id'],
            'vidhan_id' => $_POST['vidhan_id'],
            'mandal_id' => $_POST['mandal_id'],
            'booth_id' => $_POST['booth_id'],
            'address' => $_POST['address'],
            'photo' => $newphoto ?? '',
        ];

        $db->insertAry("volunteer", $aryData);
        $_SESSION['success'] = "Submitted Successfully";
        echo "<script>alert('Form submitted successfully!');</script>";
        redirect($FileName);
        unset($_POST);
    } else {
        echo "<script>alert('" . implode("\\n", $errors) . "');</script>";
    }
}
?>

<head>
    <?php include('inc_meta.php') ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/css/bootstrap.min.css">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.4.1/js/bootstrap.min.js"></script>

    <style>
        .selects {
            padding: 12px;
            width: 100%;
            background-color: #e9ecef;
            border: 1px solid #cfcfcf;
            border-radius: 8px;
            box-sizing: border-box;
        }
        /* small spacing fix for inline rows */
        .inline-row { margin-top: 10px; }
    </style>
</head>

<body>
    <div class="container-fluid" style="margin-top:20px;margin-bottom:20px;">
        <div class="conatiner" style="border: 1px solid; padding:15px;margin:0px 20px;padding-bottom:45px;margin-bottom:20px;border-radius:15px;">
            <form action="" method="post" enctype="multipart/form-data">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>नाम / Name</label><br>
                                <input type="text" name="naam" style="padding:15px;width:90%;background-color:#e9ecef;border:1px solid;border-radius:10px" required>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>दायित्व / Responsibility</label><br>
                                <input type="text" name="dayitva" style="padding:15px;width:90%;background-color:#e9ecef;border:1px solid;border-radius:10px" required>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>पिता का नाम / Father's Name</label><br>
                                <input type="text" name="father_name" style="padding:15px;width:90%;background-color:#e9ecef;border:1px solid;border-radius:10px" required>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>मोबाइल नं / Mobile No.</label><br>
                                <input type="text" name="mobileno" style="padding:15px;width:90%;background-color:#e9ecef;border:1px solid;border-radius:10px" required>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>जिला / District</label><br>
                                <select name="district_id" class="selects" required>
                                    <option value="">Select District</option>
                                    <?php
                                    $aryList = $db->getRows("select * from district order by id asc");
                                    foreach ($aryList as $iList) { ?>
                                        <option value="<?php echo $iList['id']; ?>"><?php echo $iList['distict_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;margin-top:10px;border-radius:10px">
                                <label>लोकसभा / Loksabha</label><br>
                                <select name="loksabha_id" class="selects" required>
                                    <option value="">Select Loksabha</option>
                                    <?php
                                    $aryList = $db->getRows("select * from loksabha order by id asc");
                                    foreach ($aryList as $iList) { ?>
                                        <option value="<?php echo $iList['id']; ?>"><?php echo $iList['loksabha_name']; ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                        </div>

                        <!-- Vidhan, Mandal and Booth in one line -->
                        <div class="row inline-row" style="width:100%; margin-left:0; margin-right:0;">
                            <div class="col-lg-4 col-md-4 col-sm-12">
                                <div style="padding:12px;background-color:#fff;border-radius:8px">
                                    <label>विधानसभा / Vidhan Sabha</label><br>
                                    <select name="vidhan_id" class="selects" required>
                                        <option value="">Select Vidhan</option>
                                        <?php
                                        $aryList = $db->getRows("select * from vidhan order by id asc");
                                        foreach ($aryList as $iList) { ?>
                                            <option value="<?php echo $iList['id']; ?>"><?php echo $iList['vidhan_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12">
                                <div style="padding:12px;background-color:#fff;border-radius:8px">
                                    <label>मंडल / Mandal</label><br>
                                    <select name="mandal_id" class="selects" required>
                                        <option value="">Select Mandal</option>
                                        <?php
                                        $aryList = $db->getRows("select * from mandal order by id asc");
                                        foreach ($aryList as $iList) { ?>
                                            <option value="<?php echo $iList['id']; ?>"><?php echo $iList['mandal_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>

                            <div class="col-lg-4 col-md-4 col-sm-12">
                                <div style="padding:12px;background-color:#fff;border-radius:8px">
                                    <label>बूथ / Booth</label><br>
                                    <select name="booth_id" class="selects" required>
                                        <option value="">Select Booth</option>
                                        <?php
                                        $aryList = $db->getRows("select * from booth order by id asc");
                                        foreach ($aryList as $iList) { ?>
                                            <option value="<?php echo $iList['id']; ?>"><?php echo $iList['booth_name']; ?></option>
                                        <?php } ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-6 col-md-6 col-sm-12">
                            <div style="padding:15px;background-color:#fff;border-radius:10px;margin-top:10px">
                                <label>पता / Address</label><br>
                                <textarea name="address" style="padding:15px;width:90%;background-color:#e9ecef;border:1px solid;border-radius:10px" required></textarea>
                            </div>
                        </div>

                        <div class="col-lg-4 col-md-12 col-sm-12" style="margin-top: 10px;">
                            <div style="padding:15px;background-color:#fff;border-radius:10px">
                                <label>फोटो अपलोड / Upload Photo</label><br>
                                <input class="form-control" type="file" name="photo" accept="image/*" style="margin-top: 10px" required>
                            </div>
                        </div>

                    </div>
                </div>

                <div class="col-lg-12" style="display: flex; justify-content:center;">
                    <button type="submit" class="thm-btn become-volunteer-page__btn" name="addnewrecord" style="background-color:#e33100;color:antiquewhite">Submit</button>
                </div>
            </form>
        </div>
    </div>

</body>

</html>





