<?php include 'views/layout/header.php'; ?>

<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4 shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">User Panel</a>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=dashboard">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link active" href="<?php echo BASE_URL; ?>?page=user&action=contacts">Contacts</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=template">Template</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=birthdays">Today's Birthdays</a></li>
      </ul>
      <a href="<?php echo BASE_URL; ?>?page=auth&action=logout" class="btn btn-outline-danger btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center bg-white">
        <h5 class="mb-0">My Contacts</h5>
        <div>
            <button type="button" class="btn btn-primary btn-sm" data-bs-toggle="modal" data-bs-target="#addContactModal">
                + Add New
            </button>
            <button type="button" class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#importContactModal">
                Import CSV
            </button>
        </div>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th>Mobile</th>
                        <th>Date of Birth</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($contacts)): ?>
                        <?php foreach ($contacts as $contact): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($contact['name']); ?></td>
                                <td><?php echo htmlspecialchars($contact['mobile']); ?></td>
                                <td><?php echo $contact['dob']; ?></td>
                                <td>
                                    <a href="<?php echo BASE_URL; ?>?page=user&action=delete_contact&id=<?php echo $contact['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this contact?');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="4" class="text-center">No contacts found. Add some!</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Add Contact Modal -->
<div class="modal fade" id="addContactModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form action="<?php echo BASE_URL; ?>?page=user&action=add_contact" method="POST">
          <div class="modal-header">
            <h5 class="modal-title">Add Contact</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <div class="mb-3">
                <label>Contact Name</label>
                <input type="text" name="name" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Mobile Number</label>
                <input type="text" name="mobile" class="form-control" required>
            </div>
            <div class="mb-3">
                <label>Date of Birth</label>
                <input type="date" name="dob" class="form-control" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-primary">Save Contact</button>
          </div>
      </form>
    </div>
  </div>
</div>

<!-- Import CSV Modal -->
<div class="modal fade" id="importContactModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form action="<?php echo BASE_URL; ?>?page=user&action=import_contacts" method="POST" enctype="multipart/form-data">
          <div class="modal-header">
            <h5 class="modal-title">Import Contacts</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
          </div>
          <div class="modal-body">
            <div class="alert alert-info small">
                CSV Format: <strong>Name, Mobile, DOB (YYYY-MM-DD)</strong><br>
                Example: <code>John Doe, 919876543210, 1990-05-15</code>
            </div>
            <div class="mb-3">
                <label>Select CSV File</label>
                <input type="file" name="csv_file" class="form-control" accept=".csv" required>
            </div>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            <button type="submit" class="btn btn-success">Import</button>
          </div>
      </form>
    </div>
  </div>
</div>

<?php include 'views/layout/footer.php'; ?>
