<?php include 'views/layout/header.php'; ?>

<nav class="navbar navbar-expand-lg navbar-light bg-light mb-4 shadow-sm">
  <div class="container-fluid">
    <a class="navbar-brand" href="#">User Panel</a>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto">
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=dashboard">Dashboard</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=contacts">Contacts</a></li>
        <li class="nav-item"><a class="nav-link" href="<?php echo BASE_URL; ?>?page=user&action=template">Template</a></li>
        <li class="nav-item"><a class="nav-link active" href="<?php echo BASE_URL; ?>?page=user&action=birthdays">Today's Birthdays</a></li>
      </ul>
      <a href="<?php echo BASE_URL; ?>?page=auth&action=logout" class="btn btn-outline-danger btn-sm">Logout</a>
    </div>
  </div>
</nav>

<div class="card">
    <div class="card-header bg-success text-white">
        <h5 class="mb-0">Today's Birthdays (<?php echo date('d M Y'); ?>)</h5>
    </div>
    <div class="card-body">
        <?php if (!empty($birthdays)): ?>
            <div class="alert alert-info">
                Found <strong><?php echo count($birthdays); ?></strong> birthdays today.
            </div>

            <div class="table-responsive mb-4">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>Name</th>
                            <th>Mobile</th>
                            <th>Age Turning</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($birthdays as $bday):
                            $age = date('Y') - date('Y', strtotime($bday['dob']));
                        ?>
                            <tr>
                                <td><?php echo htmlspecialchars($bday['name']); ?></td>
                                <td><?php echo htmlspecialchars($bday['mobile']); ?></td>
                                <td><?php echo $age; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>

            <form action="<?php echo BASE_URL; ?>?page=user&action=send_wishes" method="POST">
                <button type="submit" class="btn btn-lg btn-primary w-100 send-btn">
                    SEND BIRTHDAY MESSAGES 🚀
                </button>
                <div class="form-text text-center mt-2">
                    This will generate PDFs and send WhatsApp/SMS to all above contacts.
                </div>
            </form>

        <?php else: ?>
            <div class="text-center py-5">
                <h3 class="text-muted">No birthdays today! 🎉</h3>
                <p>Relax and enjoy your day.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include 'views/layout/footer.php'; ?>
