<?php include 'views/layout/header.php'; ?>
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4>Register New Account</h4>
            </div>
            <div class="card-body">
                <form action="<?php echo BASE_URL; ?>?page=auth&action=register" method="POST" enctype="multipart/form-data">

                    <h5 class="mb-3 text-primary">Personal Details</h5>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Full Name</label>
                            <input type="text" name="name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Mobile Number</label>
                            <input type="text" name="mobile" class="form-control" required>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label>Email Address</label>
                        <input type="email" name="email" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label>Password</label>
                        <input type="password" name="password" class="form-control" required>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">WhatsApp API Details</h5>
                    <div class="alert alert-warning py-1 small">⚠️ Cannot be edited later</div>
                    <div class="mb-3">
                        <label>WhatsApp API URL</label>
                        <input type="text" name="wa_url" class="form-control" placeholder="https://api.example.com/send" required>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label>Instance ID</label>
                            <input type="text" name="wa_instance" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label>Access Token</label>
                            <input type="text" name="wa_token" class="form-control" required>
                        </div>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">SMS API Details</h5>
                    <div class="mb-3">
                        <label>SMS API URL</label>
                        <input type="text" name="sms_url" class="form-control" placeholder="https://sms.example.com/api?..." required>
                    </div>
                    <div class="mb-3">
                        <label>API Key / Auth Key</label>
                        <input type="text" name="sms_key" class="form-control" required>
                    </div>

                    <hr>
                    <h5 class="mb-3 text-primary">Birthday Template</h5>
                    <div class="mb-3">
                        <label>Upload Template Image (JPG/PNG)</label>
                        <input type="file" name="template_image" class="form-control" accept="image/jpeg, image/png" required>
                        <small class="text-muted">Upload a clean image. System will write Name on it.</small>
                    </div>

                    <button type="submit" class="btn btn-primary w-100">Register & Setup APIs</button>
                </form>
                <div class="mt-3 text-center">
                    <a href="<?php echo BASE_URL; ?>?page=auth&action=login">Already have an account? Login</a>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include 'views/layout/footer.php'; ?>
