<?php include 'views/layout/header.php'; ?>

<nav class="navbar navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <span class="navbar-brand mb-0 h1">Admin Panel</span>
    <a href="<?php echo BASE_URL; ?>?page=auth&action=logout" class="btn btn-outline-light btn-sm">Logout</a>
  </div>
</nav>

<div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
        <h5 class="mb-0">Registered Users</h5>
        <a href="<?php echo BASE_URL; ?>?page=admin&action=add_user" class="btn btn-primary btn-sm">+ Add New User</a>
    </div>
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-bordered table-hover">
                <thead class="table-light">
                    <tr>
                        <th>ID</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Mobile</th>
                        <th>Status</th>
                        <th>Created At</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($users)): ?>
                        <?php foreach ($users as $user): ?>
                            <tr>
                                <td><?php echo $user['id']; ?></td>
                                <td><?php echo htmlspecialchars($user['name']); ?></td>
                                <td><?php echo htmlspecialchars($user['email']); ?></td>
                                <td><?php echo htmlspecialchars($user['mobile']); ?></td>
                                <td>
                                    <?php if ($user['status'] == 'active'): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo $user['created_at']; ?></td>
                                <td>
                                    <?php if ($user['status'] == 'active'): ?>
                                        <a href="<?php echo BASE_URL; ?>?page=admin&action=deactivate&id=<?php echo $user['id']; ?>" class="btn btn-warning btn-sm">Deactivate</a>
                                    <?php else: ?>
                                        <a href="<?php echo BASE_URL; ?>?page=admin&action=activate&id=<?php echo $user['id']; ?>" class="btn btn-success btn-sm">Activate</a>
                                    <?php endif; ?>

                                    <a href="<?php echo BASE_URL; ?>?page=admin&action=delete&id=<?php echo $user['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure? This will delete all user data including contacts and templates.');">Delete</a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center">No users found.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'views/layout/footer.php'; ?>
