<?php
require_once 'config/db.php';

// Generate hash for 'admin123'
$pass = 'admin123';
$hash = password_hash($pass, PASSWORD_BCRYPT);

$username = 'admin';

// Check if admin exists
$stmt = $conn->prepare("SELECT id FROM admins WHERE username = ?");
$stmt->bind_param("s", $username);
$stmt->execute();
$res = $stmt->get_result();

if ($res->num_rows > 0) {
    // Update
    $update = $conn->prepare("UPDATE admins SET password = ? WHERE username = ?");
    $update->bind_param("ss", $hash, $username);
    if ($update->execute()) {
        echo "<h1>Success</h1><p>Admin password reset to: <strong>$pass</strong></p>";
        echo "<p>Hash: $hash</p>";
    } else {
        echo "Error updating: " . $conn->error;
    }
} else {
    // Insert
    $ins = $conn->prepare("INSERT INTO admins (username, password) VALUES (?, ?)");
    $ins->bind_param("ss", $username, $hash);
    if ($ins->execute()) {
        echo "<h1>Success</h1><p>Admin created with password: <strong>$pass</strong></p>";
    } else {
        echo "Error creating: " . $conn->error;
    }
}

echo '<br><a href="index.php?page=auth&action=admin_login">Go to Login</a>';
?>
