<?php
// Base URL - Update this according to your local setup
define('BASE_URL', 'http://localhost/birthday_msg/');

// Path Constants
define('ROOT_PATH', __DIR__ . '/../');
define('ASSETS_URL', BASE_URL . 'assets/');
define('UPLOADS_URL', BASE_URL . 'uploads/');
define('TEMPLATE_PATH', ROOT_PATH . 'uploads/templates/');

// Flash Message Helpers
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

function setFlash($key, $message, $type = 'success') {
    $_SESSION['flash'][$key] = ['msg' => $message, 'type' => $type];
}

function getFlash($key) {
    if (isset($_SESSION['flash'][$key])) {
        $flash = $_SESSION['flash'][$key];
        unset($_SESSION['flash'][$key]);
        return $flash;
    }
    return null;
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function isAdmin() {
    return isset($_SESSION['admin_id']);
}
?>
